/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.subscribermanager.SubscriberManagerConfig;
import com.bwanms.model.ManagedEntityBase;
import com.bwanms.model.Service;
import com.bwanms.model.Subscriber;
import com.bwanms.persistence.Datastore;
import com.bwanms.services.SubscriberManagementService;
import com.bwanms.util.ServerValidationException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriberManagementServiceImpl
implements SubscriberManagementService {
    @Override
    public Subscriber save(Subscriber subscriber) throws ServerValidationException {
        List match = Datastore.session().createQuery(" from " + Subscriber.class.getName() + " where subscriberId=:subscriberId and id!=:id").setString("subscriberId", subscriber.getSubscriberId()).setLong("id", subscriber.getId()).list();
        if (match.size() > 0) {
            Internationalizer i18n = Internationalizer.getInternationalizer(SubscriberManagerConfig.class);
            ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
            iValues.add(new InvalidValue(i18n.translateString("uniqueViolation"), Subscriber.class, "subscriberId", (Object)subscriber.getSubscriberId(), (Object)subscriber));
            throw new ServerValidationException(iValues);
        }
        if (subscriber.getId() == 0L) {
            ManagedEntityBase.persist(Datastore.session(), subscriber);
        }
        Datastore.session().saveOrUpdate((Object)subscriber);
        return subscriber;
    }

    @Override
    public void delete(Subscriber subscriber) throws ServerValidationException {
        List match = Datastore.session().createQuery(" from " + Service.class.getName() + " as serv where serv.subscriber.id=:id").setLong("id", subscriber.getId()).list();
        if (match.size() > 0) {
            System.out.println(match);
            Internationalizer i18n = Internationalizer.getInternationalizer(SubscriberManagerConfig.class);
            ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
            iValues.add(new InvalidValue(i18n.translateString("serviceViolation"), Subscriber.class, "subscriberId", (Object)subscriber.getSubscriberId(), (Object)subscriber));
            throw new ServerValidationException(iValues);
        }
        Datastore.session().delete((Object)subscriber);
    }

    @Override
    public List<Long> delete(List<Subscriber> subscribers) {
        ArrayList<Long> notDeleted = new ArrayList<Long>();
        for (Subscriber subscriber : subscribers) {
            try {
                this.delete(subscriber);
            }
            catch (ServerValidationException e) {
                notDeleted.add(subscriber.getId());
            }
        }
        return notDeleted;
    }
}

