/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.model.Settings;
import com.bwanms.persistence.Datastore;
import com.bwanms.services.SettingsService;
import org.hibernate.Query;

public class SettingsServiceImpl
implements SettingsService {
    private final String baseQueryString;

    public SettingsServiceImpl() {
        StringBuilder sb = new StringBuilder();
        sb.append(" from ").append(Settings.class.getName());
        sb.append(" where owner ");
        this.baseQueryString = sb.toString();
    }

    public Settings fetchSettings(String owner, boolean create) {
        if (owner == null) {
            throw new NullPointerException();
        }
        Query query = Datastore.session().createQuery(this.baseQueryString + "= :owner");
        query.setString("owner", owner);
        Settings ret = (Settings)query.uniqueResult();
        if (ret == null) {
            if (create) {
                ret = new Settings();
                ret.setOwner(owner);
            }
        } else {
            ret.getProperty("", "");
        }
        return ret;
    }

    public void updateSettings(Settings settings) {
        Datastore.session().saveOrUpdate((Object)settings);
    }

    public void removeSettings(String owner) {
        if ("<GLOBAL_OWNER>".equals(owner)) {
            return;
        }
        Settings settings = this.fetchSettings(owner, false);
        if (null != settings) {
            Datastore.session().delete((Object)settings);
        }
    }
}

