/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.ddi.DDRegistry;
import com.bwanms.ddi.ServiceManagementStrategy;
import com.bwanms.domain.logic.Helpers;
import com.bwanms.model.Equipment;
import com.bwanms.model.Service;
import com.bwanms.model.ServiceProfile;
import com.bwanms.model.Subscriber;
import com.bwanms.persistence.Datastore;
import com.bwanms.services.ServiceManagementService;
import com.bwanms.util.ServerValidationException;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManagementServiceImpl
implements ServiceManagementService {
    private static final Logger logger = Logger.getLogger(ServiceManagementServiceImpl.class);

    @Override
    public ServiceProfile retrieveServiceProfile(long serviceProfileId) {
        return (ServiceProfile)Datastore.session().get(ServiceProfile.class, (Serializable)new Long(serviceProfileId));
    }

    @Override
    public ServiceProfile updateServiceProfile(ServiceProfile serviceProfile) throws ServerValidationException {
        ServiceManagementStrategy mgmt = this.getServiceManagementStrategy(serviceProfile);
        return mgmt.updateServiceProfile(serviceProfile);
    }

    @Override
    public void deleteServiceProfile(long serviceProfileId) throws ServerValidationException {
        ServiceProfile serviceProfile = this.retrieveServiceProfile(serviceProfileId);
        ServiceManagementStrategy mgmt = this.getServiceManagementStrategy(serviceProfile);
        mgmt.deleteServiceProfile(serviceProfile);
    }

    @Override
    public List<Equipment> findServiceProfileInstances(long serviceProfileId) {
        ServiceProfile serviceProfile = this.retrieveServiceProfile(serviceProfileId);
        ServiceManagementStrategy mgmt = this.getServiceManagementStrategy(serviceProfile);
        return mgmt.findServiceProfileInstances(serviceProfile);
    }

    @Override
    public void deployServiceProfile(long spId, long targetEquipmentId) {
        ServiceProfile serviceProfile = this.retrieveServiceProfile(spId);
        ServiceManagementStrategy mgmtStrategy = this.getServiceManagementStrategy(serviceProfile);
        try {
            mgmtStrategy.deployServiceProfile(serviceProfile, this.retrieveEquipment(targetEquipmentId));
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void undeployServiceProfile(long spId, long targetEquipmentId) {
        ServiceProfile serviceProfile = this.retrieveServiceProfile(spId);
        if (!serviceProfile.getServices().isEmpty()) {
            throw new RuntimeException("Service Profile is in use!");
        }
        ServiceManagementStrategy mgmtStrategy = this.getServiceManagementStrategy(serviceProfile);
        try {
            mgmtStrategy.undeployServiceProfile(serviceProfile, this.retrieveEquipment(targetEquipmentId));
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public Service retrieveService(long serviceId) {
        return (Service)Datastore.session().get(Service.class, (Serializable)new Long(serviceId));
    }

    @Override
    public Service updateService(Service service) throws ServerValidationException {
        throw new AssertionError((Object)"Services NOT persistent! No Global Services!! ");
    }

    @Override
    public void deleteService(long serviceId) throws ServerValidationException {
        Service service = this.retrieveService(serviceId);
        ServiceManagementStrategy mgmt = this.getServiceManagementStrategy(service);
        mgmt.deleteService(service);
    }

    @Override
    public List<Equipment> findServiceInstances(long serviceId) {
        Service service = this.retrieveService(serviceId);
        ServiceManagementStrategy mgmt = this.getServiceManagementStrategy(service);
        return mgmt.findServiceInstances(service);
    }

    @Override
    public void deployService(long serviceId, long targetEquipmentId) {
        Service service = this.retrieveService(serviceId);
        ServiceManagementStrategy mgmt = this.getServiceManagementStrategy(service);
        try {
            mgmt.deployService(service, this.retrieveEquipment(targetEquipmentId));
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void undeployService(long serviceId, long targetEquipmentId) {
        Service service = this.retrieveService(serviceId);
        ServiceManagementStrategy mgmt = this.getServiceManagementStrategy(service);
        try {
            mgmt.undeployService(service, this.retrieveEquipment(targetEquipmentId));
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public Subscriber retrieveSubscriber(long subscriberId) {
        return (Subscriber)Datastore.session().get(Subscriber.class, (Serializable)new Long(subscriberId));
    }

    @Override
    public Subscriber updateSubscriber(Subscriber subscriber) throws ServerValidationException {
        subscriber.setSubscriberEntries(null);
        subscriber.setSubscriberEntriesEnabled(null);
        ServiceManagementStrategy mgmt = this.getServiceManagementStrategy(subscriber);
        return mgmt.updateSubscriber(subscriber);
    }

    @Override
    public void deleteSubscriber(long subscriberId) throws ServerValidationException {
        Subscriber subscriber = this.retrieveSubscriber(subscriberId);
        ServiceManagementStrategy mgmt = this.getServiceManagementStrategy(subscriber);
        mgmt.deleteSubscriber(subscriber);
    }

    @Override
    public List<Equipment> findSubscriberInstances(long subscriberId) {
        Subscriber subscriber = this.retrieveSubscriber(subscriberId);
        ServiceManagementStrategy mgmt = this.getServiceManagementStrategy(subscriber);
        return mgmt.findSubscriberInstances(subscriber);
    }

    @Override
    public void deploySubscriber(long subscriberId, long targetEquipmentId) {
        Subscriber subscriber = this.retrieveSubscriber(subscriberId);
        ServiceManagementStrategy mgmt = this.getServiceManagementStrategy(subscriber);
        try {
            mgmt.deploySubscriber(subscriber, this.retrieveEquipment(targetEquipmentId));
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void undeploySubscriber(long subscriberId, long targetEquipmentId) {
        Subscriber subscriber = this.retrieveSubscriber(subscriberId);
        ServiceManagementStrategy mgmt = this.getServiceManagementStrategy(subscriber);
        try {
            mgmt.undeploySubscriber(subscriber, this.retrieveEquipment(targetEquipmentId));
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private ServiceManagementStrategy getServiceManagementStrategy(Service service) {
        return DDRegistry.getInstance().getDDInterfaceByServiceClass(service.getClass().getName()).getServiceManagementStrategy(Helpers.getDDCallback());
    }

    private ServiceManagementStrategy getServiceManagementStrategy(ServiceProfile serviceProfile) {
        return DDRegistry.getInstance().getDDInterfaceByServiceProfileClass(serviceProfile.getClass().getName()).getServiceManagementStrategy(Helpers.getDDCallback());
    }

    private ServiceManagementStrategy getServiceManagementStrategy(Subscriber subscriber) {
        return DDRegistry.getInstance().getDDInterfaceBySubscriberClass(subscriber.getClass().getName()).getServiceManagementStrategy(Helpers.getDDCallback());
    }

    private Equipment retrieveEquipment(long equipmentId) {
        return (Equipment)Datastore.session().get(Equipment.class, (Serializable)new Long(equipmentId));
    }
}

