/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.gui.Internationalizer;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.plugin.IPluginDefinition;
import com.bwanms.plugin.impl.PluginDefinition;
import com.bwanms.services.ServerUtilService;
import com.bwanms.util.ServerTime;
import com.bwanms.util.SystemPropertyUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerUtilServiceImpl
implements ServerUtilService {
    public static final String PLUGIN_MODULE_INFR = "ngnms";
    private static IPluginDefinition serverInfrInfo;
    private static List<IPluginDefinition> serverDDInfoList;

    @Override
    public ServerTime getTime() {
        ServerTime serverTime = new ServerTime();
        return serverTime;
    }

    @Override
    public List<IPluginDefinition> retrieveServerDDInfoList() {
        if (serverDDInfoList == null) {
            ServerUtilServiceImpl.getServerInfo();
        }
        return serverDDInfoList;
    }

    @Override
    public IPluginDefinition retrieveServerInfrInfo() {
        if (serverInfrInfo == null) {
            ServerUtilServiceImpl.getServerInfo();
        }
        return serverInfrInfo;
    }

    private static final void getServerInfo() {
        serverDDInfoList = new ArrayList<IPluginDefinition>();
        serverInfrInfo = new PluginDefinition("", "", "", "", "", "");
        Internationalizer ddiI18n = null;
        try {
            ddiI18n = Internationalizer.getInternationalizer("com.bwanms.ddi");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
            IPluginDefinition[] plugins = null;
            if (extensionRegistry != null) {
                for (IPluginDefinition plugin : plugins = extensionRegistry.getPlugins()) {
                    String pluginModule = plugin.getModule();
                    PluginDefinition pluginDef = new PluginDefinition(plugin.getNamespace(), plugin.getName(), plugin.getVersion(), plugin.getInfo(), plugin.getModule(), ddiI18n != null ? ddiI18n.translateString(plugin.getName()) : plugin.getName());
                    if (PLUGIN_MODULE_INFR.equalsIgnoreCase(pluginModule)) {
                        serverInfrInfo = pluginDef;
                        continue;
                    }
                    serverDDInfoList.add(pluginDef);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String retrieveRegionalName() {
        return SystemPropertyUtil.getString("com.bwanms.regionalName", "");
    }

    @Override
    public String retrievePartitionName() {
        String property = System.getProperty("oware.client.partition.name");
        return property == null ? "" : property;
    }
}

