/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.model.Schedule;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.schedule.ScheduleHelper;
import com.bwanms.schedule.jobs.RunnableJob;
import com.bwanms.services.SchedulerService;
import java.util.Date;
import org.apache.log4j.Logger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class SchedulerServiceImpl
implements SchedulerService {
    private static final Logger log = Logger.getLogger(SchedulerServiceImpl.class);
    private Scheduler scheduler;

    public Date startOrUpdateSchedule(Schedule schedule) {
        try {
            this.getScheduler().deleteJob("job-" + schedule.getId(), "DEFAULT");
        }
        catch (SchedulerException e1) {
            throw new RuntimeException(e1);
        }
        JobDetail jobDetail = new JobDetail("job-" + schedule.getId(), "DEFAULT", RunnableJob.class);
        jobDetail.getJobDataMap().put((Object)"runnable", (Object)schedule.getRunnableJob());
        Trigger trigger = ScheduleHelper.makeTrigger(schedule);
        try {
            this.getScheduler().scheduleJob(jobDetail, trigger);
            return trigger.getFireTimeAfter(new Date());
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public void stopSchedule(Schedule schedule) {
        try {
            this.getScheduler().deleteJob("job-" + schedule.getId(), "DEFAULT");
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    private Scheduler getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = (Scheduler)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("Quartz");
        }
        return this.scheduler;
    }

    public Date getNextFireTime(long scheduleId) {
        try {
            Trigger trigger = this.getScheduler().getTrigger("trigger-" + scheduleId, "DEFAULT");
            if (trigger != null) {
                Date nextTime = trigger.getFireTimeAfter(new Date());
                log.debug((Object)String.format("schedule %d Trigger next fire time %tc", scheduleId, nextTime));
                return nextTime;
            }
            log.debug((Object)("schedule " + scheduleId + " trigger null, next fire time null"));
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        return null;
    }
}

