/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.be.QueueHelper;
import com.bwanms.be.QueueI;
import com.bwanms.be.QueueIListener;
import com.bwanms.model.fault.Event;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueueListenerWorker
implements QueueIListener,
Runnable {
    private static final Logger log = Logger.getLogger(QueueListenerWorker.class);
    protected final QueueI<Event> queue;
    protected int interval = 500;
    protected int batchSize = 500;
    private AtomicBoolean stop = new AtomicBoolean(true);
    private AtomicBoolean notificationGetBatch = new AtomicBoolean(false);
    private long lastTime;
    private final String name;

    public QueueListenerWorker(QueueI<Event> queue, String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name can't be null");
        }
        this.queue = queue;
        this.queue.setQueueListener(this);
        this.name = name;
    }

    @Override
    public void run() {
        while (this.stop.get()) {
            long currentTime = System.currentTimeMillis();
            if (this.notificationGetBatch.get() || currentTime - this.lastTime >= (long)this.interval) {
                this.lastTime = currentTime;
                if (this.queue.size() == 0) continue;
                ArrayList<Event> list = new ArrayList<Event>(this.batchSize);
                this.queue.drainTo(list, this.batchSize);
                log.debug((Object)String.format("%s : batch size = %d, queue remaining size = %d", this.name, list.size(), this.queue.size()));
                this.templateProcessing(list);
                for (Event event : list) {
                    event.setLastUpdateTime(currentTime);
                }
                this.dbPersistence(list);
                try {
                    QueueHelper.pushMsg(list, "queue/NbiEvent");
                }
                catch (Exception ex) {
                    log.debug((Object)ex.getMessage(), (Throwable)ex);
                    ex.printStackTrace();
                }
                this.passListToCorelate(list);
                log.debug((Object)("QueueListenerWorker " + this.name + ": step took " + (System.currentTimeMillis() - this.lastTime) + " milliseconds for " + list.size() + " objects"));
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                this.stop.set(false);
            }
        }
    }

    @Override
    public void notifyGetBatch() {
        this.notificationGetBatch.set(true);
    }

    public void prepareToStop() {
        this.stop.set(false);
    }

    protected abstract void templateProcessing(ArrayList<Event> var1);

    protected abstract void dbPersistence(ArrayList<Event> var1);

    protected void passListToCorelate(ArrayList<Event> list) {
    }
}

