/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.model.task.PerformanceCollectionGenericTask;
import com.bwanms.performance.PMCollectionEntityTypeUtil;
import com.bwanms.performance.PerformanceCollectionEntity;
import com.bwanms.performance.PerformanceCollectionLookup;
import com.bwanms.performance.db.PmCollectionVariable;
import com.bwanms.performance.db.PmDirectDataCollectorUtil;
import com.bwanms.persistence.Datastore;
import com.bwanms.services.PerformanceCollectionViewerResponse;
import com.bwanms.services.PerformanceCollectionViewerService;
import com.ngnms.apps.pmcollection.AvPmCollectionUtil;
import com.ngnms.apps.pmcollection.db.AvPmDisplayData;
import com.ngnms.common.AvException;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceCollectionViewerServiceImpl
implements PerformanceCollectionViewerService {
    private static final Logger logger = Logger.getLogger(PerformanceCollectionViewerServiceImpl.class);

    @Override
    public List<PerformanceCollectionViewerResponse> retrieveData(long taskId, Hashtable<String, Object> collVars, long startTime, long endTime) {
        String sessionName = String.valueOf(taskId);
        PerformanceCollectionGenericTask task = PerformanceCollectionViewerServiceImpl.retrieveTaskDecorated(sessionName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\t\tstartTime: " + new Date(startTime)));
            logger.debug((Object)("\t\tendTime: " + new Date(endTime)));
        }
        ArrayList<PerformanceCollectionViewerResponse> responses = new ArrayList<PerformanceCollectionViewerResponse>();
        Iterator<String> it = collVars.keySet().iterator();
        while (it.hasNext()) {
            try {
                String targetNRKey = it.next();
                List vars = (List)collVars.get(targetNRKey);
                Map<String, Vector<String>> _varsByRowID = null;
                if (1 != vars.size() || !"{all}".equals((String)vars.get(0))) {
                    _varsByRowID = this.groupVarsByRowID(vars);
                    logger.debug((Object)("AvFormGetPmDataRule.groupVarsByRowID() - size is " + _varsByRowID.size()));
                }
                long _tm = System.currentTimeMillis();
                int interval = PmDirectDataCollectorUtil.getDisplayInterval(startTime, endTime);
                if (-1 == interval) {
                    interval = task.getPollingInterval() * 60;
                }
                List<AvPmDisplayData> dbValues = PmDirectDataCollectorUtil.getDisplayDataValues(sessionName, targetNRKey, null != _varsByRowID ? new Vector<String>(_varsByRowID.keySet()) : null, startTime, endTime);
                logger.debug((Object)("AvPmDataCollectorUtil.getDataValues() - size is " + dbValues.size() + "  time is " + (System.currentTimeMillis() - _tm)));
                if (null == _varsByRowID) {
                    TreeSet<String> _rowIDsSet = new TreeSet<String>();
                    for (AvPmDisplayData pmdata : dbValues) {
                        if (_rowIDsSet.contains(pmdata.getRowID())) continue;
                        _rowIDsSet.add(pmdata.getRowID());
                    }
                    PerformanceCollectionEntity entity = PerformanceCollectionViewerServiceImpl.getPMEntity(task, targetNRKey);
                    _varsByRowID = PerformanceCollectionViewerServiceImpl.groupCollVarsByRowID((List)((Object)entity.getCounters()), _rowIDsSet);
                }
                Hashtable<String, Object[]> profValues = this.processDbValues(_varsByRowID, dbValues);
                Hashtable<String, Hashtable<String, Object[]>> collValues = new Hashtable<String, Hashtable<String, Object[]>>();
                collValues.put(targetNRKey, profValues);
                responses.add(new PerformanceCollectionViewerResponse(collValues, interval));
                logger.debug((Object)("Response for PM Data collValues size: " + collValues.size() + "   interval: " + interval));
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return responses;
    }

    @Override
    public Object getCounters(long taskId, String entityId, String entityType) {
        String sessionName = String.valueOf(taskId);
        try {
            PerformanceCollectionEntity pcEntity = (PerformanceCollectionEntity)Datastore.session().get(PerformanceCollectionEntity.class, (Serializable)new Long(entityId));
            Vector profileCollVars = this.getCollectionVariables(sessionName, pcEntity);
            LinkedHashMap<String, AbstractCollection> varCats = new LinkedHashMap<String, AbstractCollection>();
            LinkedHashMap<String, String> varOids = new LinkedHashMap<String, String>();
            LinkedHashSet<String> varNames = new LinkedHashSet<String>();
            for (PmCollectionVariable cv : profileCollVars) {
                if (-1 == cv.getType()) continue;
                String varName = cv.getName();
                String varOid = cv.getSnmpOid();
                logger.debug((Object)("Got: " + varName + " " + varOid));
                int bracketIdx = varName.indexOf("[");
                if (bracketIdx != -1) {
                    varName = varName.substring(0, bracketIdx);
                }
                varNames.add(varName);
                int colonIndex = varOid.indexOf(":");
                varOids.put(varName, varOid.substring(0, colonIndex));
                varOid = varOid.substring(colonIndex + 1);
                int doubleColonIndex = varOid.indexOf("::");
                if (doubleColonIndex == -1) {
                    if (varCats.containsKey(varOid)) continue;
                    varCats.put(varOid, new Vector());
                    continue;
                }
                String varInstance = varOid.substring(doubleColonIndex + 2);
                LinkedHashSet<String> varInstances = (LinkedHashSet<String>)varCats.get(varOid = varOid.substring(0, doubleColonIndex));
                if (varInstances == null) {
                    varInstances = new LinkedHashSet<String>();
                    varCats.put(varOid, varInstances);
                    varInstances.add(varInstance);
                    continue;
                }
                if (varInstances.contains(varInstance)) continue;
                varInstances.add(varInstance);
            }
            logger.debug((Object)("VarCats: " + varCats));
            logger.debug((Object)("VarNames: " + varNames));
            Map iniCategories = PerformanceCollectionViewerServiceImpl.getPMCollectionVariablesForME(pcEntity.getEntity(), entityType, "PMCollectionCategories");
            this.pruneCategory(iniCategories, varCats, varNames);
            this.inflateInstances(iniCategories, varCats, varOids);
            this.pruneEmptyCategories(iniCategories, varCats);
            return iniCategories;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return new LinkedHashMap();
        }
    }

    private static PerformanceCollectionGenericTask retrieveTaskDecorated(String taskId) {
        return (PerformanceCollectionGenericTask)Datastore.session().get(PerformanceCollectionGenericTask.class, (Serializable)new Long(taskId));
    }

    Hashtable<String, Object[]> processDbValues(Map<String, Vector<String>> pVarsByRowID, List<AvPmDisplayData> pValues) throws AvException {
        Hashtable<String, Object[]> ret = new Hashtable<String, Object[]>();
        Hashtable<String, Vector<AvPmDisplayData>> valuesByRowID = this.groupValuesByRowID(pValues);
        for (String crtRowID : pVarsByRowID.keySet()) {
            Vector<String> _cvs = pVarsByRowID.get(crtRowID);
            int varsSize = _cvs.size();
            Vector<AvPmDisplayData> _vals = valuesByRowID.get(crtRowID);
            int valuesSize = null != _vals ? _vals.size() : 0;
            int[] cvPos = new int[varsSize];
            long[][] timestamps = new long[varsSize][valuesSize];
            double[][] datavalues = new double[varsSize][valuesSize];
            for (int j = 0; j < varsSize; ++j) {
                String _cv = _cvs.get(j);
                int _scolonidx = _cv.indexOf(58);
                cvPos[j] = Integer.parseInt(_cv.substring(0, _scolonidx));
                ret.put(_cv, new Object[]{timestamps[j], datavalues[j]});
            }
            for (int i = 0; i < valuesSize; ++i) {
                AvPmDisplayData pmdata = _vals.get(i);
                long _cTime = pmdata.getCollectionTime();
                double[] _data = pmdata.getData();
                for (int j = 0; j < varsSize; ++j) {
                    timestamps[j][i] = _cTime;
                    if (cvPos[j] < _data.length) {
                        datavalues[j][i] = _data[cvPos[j]];
                        continue;
                    }
                    datavalues[j][i] = Double.NaN;
                    logger.debug((Object)("Invalid Position!!!  rowID: [" + crtRowID + "]    pos[" + _cvs.get(j) + "]: " + cvPos[j]));
                }
            }
        }
        return ret;
    }

    private Map<String, Vector<String>> groupVarsByRowID(List<String> pVars) throws Exception {
        TreeMap<String, Vector<String>> _tm = new TreeMap<String, Vector<String>>();
        for (String _cv : pVars) {
            int _idx;
            String _inst = _cv.substring((_idx = _cv.indexOf("::")) + 2);
            Vector<String> _v = _tm.get(_inst);
            if (null == _v) {
                _v = new Vector();
                _tm.put(_inst, _v);
            }
            _v.add(_cv);
        }
        if (logger.isDebugEnabled()) {
            Iterator<String> it = _tm.keySet().iterator();
            while (it.hasNext()) {
                System.out.println("-------- row Instance: [" + it.next() + "]");
            }
        }
        return _tm;
    }

    Hashtable<String, Vector<AvPmDisplayData>> groupValuesByRowID(List<AvPmDisplayData> pValues) {
        Hashtable<String, Vector<AvPmDisplayData>> ret = new Hashtable<String, Vector<AvPmDisplayData>>();
        for (AvPmDisplayData pmdata : pValues) {
            Vector<Object> _v = ret.get(pmdata.getRowID());
            if (null == _v) {
                _v = new Vector();
                ret.put(pmdata.getRowID(), _v);
            }
            _v.add(pmdata);
        }
        return ret;
    }

    private static PerformanceCollectionEntity getPMEntity(PerformanceCollectionGenericTask task, String managedEntityId) {
        Long meId = new Long(managedEntityId);
        for (PerformanceCollectionEntity entity : task.getEntities()) {
            if (meId.longValue() != entity.getEntityId()) continue;
            return entity;
        }
        return null;
    }

    private static Map<String, Vector<String>> groupCollVarsByRowID(List<Object[]> counters, Collection<String> pRowIDs) {
        TreeMap<String, Vector<String>> ret = new TreeMap<String, Vector<String>>();
        if (null == counters) {
            return ret;
        }
        for (Object[] counter : counters) {
            String name = (String)counter[0];
            List keys = (List)counter[1];
            List vars = (List)counter[2];
            if (null == keys) {
                Vector<String> toAdd = new Vector<String>();
                for (int i = 0; i < vars.size(); ++i) {
                    PmCollectionVariable cv = (PmCollectionVariable)vars.get(i);
                    if (-1 == cv.getType()) continue;
                    String varID = Integer.toString(i) + ':' + cv.getName();
                    toAdd.add(varID);
                    logger.debug((Object)("groupCollVarsByRowID: " + name + " - " + varID));
                }
                ret.put(name, toAdd);
                continue;
            }
            for (String rowID : pRowIDs) {
                String rowInst;
                int dblDotIdx = rowID.indexOf("::");
                String rowName = -1 != dblDotIdx ? rowID.substring(0, dblDotIdx) : rowID;
                String string = rowInst = -1 != dblDotIdx ? rowID.substring(dblDotIdx + 2) : null;
                if (!name.equals(rowName)) continue;
                Vector<String> toAdd = new Vector<String>();
                for (int i = 0; i < vars.size(); ++i) {
                    PmCollectionVariable cv = (PmCollectionVariable)vars.get(i);
                    if (-1 == cv.getType()) continue;
                    String varID = Integer.toString(i) + ':' + cv.getName();
                    if (null != rowInst) {
                        varID = varID + "::" + rowInst;
                    }
                    toAdd.add(varID);
                    logger.debug((Object)("groupCollVarsByRowID: " + rowID + " - " + varID));
                }
                ret.put(rowID, toAdd);
            }
        }
        return ret;
    }

    private Vector getCollectionVariables(String sessionName, PerformanceCollectionEntity pcEntity) throws Exception {
        if (null == pcEntity.getEntity()) {
            return null;
        }
        List counters = (List)((Object)pcEntity.getCounters());
        if (null == counters || 0 == counters.size()) {
            return new Vector();
        }
        String nrKey = String.valueOf(pcEntity.getEntityId());
        Vector<PmCollectionVariable> ret = new Vector<PmCollectionVariable>();
        for (Object[] crtVars : counters) {
            if (null != crtVars[1]) continue;
            List _cvs = (List)crtVars[2];
            for (int j = 0; j < _cvs.size(); ++j) {
                PmCollectionVariable _cv = (PmCollectionVariable)_cvs.get(j);
                if (-1 == _cv.getType()) continue;
                PmCollectionVariable _ccv = new PmCollectionVariable();
                _ccv.setName(_cv.getName());
                _ccv.setType(_cv.getType());
                _ccv.setSnmpOid(Integer.toString(j) + ":" + crtVars[0]);
                ret.add(_ccv);
            }
        }
        List<String> rowInstances = PmDirectDataCollectorUtil.getRowInstances(sessionName, nrKey);
        if (null != rowInstances) {
            block4: for (String _rowInst : rowInstances) {
                int _sepIdx = _rowInst.indexOf("::");
                if (-1 == _sepIdx) continue;
                String _instName = _rowInst.substring(0, _sepIdx);
                String _instValue = _rowInst.substring(_sepIdx + 2);
                try {
                    for (int i = 0; i < counters.size(); ++i) {
                        Object[] crtVars = (Object[])counters.get(i);
                        String _tblName = (String)crtVars[0];
                        if (!_tblName.equals(_instName)) continue;
                        List _vc = (List)crtVars[2];
                        for (int j = 0; j < _vc.size(); ++j) {
                            PmCollectionVariable _cv = (PmCollectionVariable)_vc.get(j);
                            if (-1 == _cv.getType()) continue;
                            PmCollectionVariable _ccv = new PmCollectionVariable();
                            _ccv.setName(_cv.getName() + "[ " + _instValue + " ]");
                            _ccv.setType(_cv.getType());
                            _ccv.setSnmpOid(Integer.toString(j) + ":" + _rowInst);
                            ret.add(_ccv);
                        }
                        continue block4;
                    }
                }
                catch (Exception _e) {
                    _e.printStackTrace();
                }
            }
        }
        return ret;
    }

    private void pruneCategory(Map pCategoryHash, Map pSelectedCounters, Set pSelectedNames) {
        Iterator i = pCategoryHash.keySet().iterator();
        while (i.hasNext()) {
            String catName = (String)i.next();
            Object catValue = pCategoryHash.get(catName);
            if (catValue instanceof Map) {
                Map catValueHash = (Map)catValue;
                this.pruneCategory(catValueHash, pSelectedCounters, pSelectedNames);
                if (!catValueHash.isEmpty()) continue;
                logger.debug((Object)("Pruning 1: " + catName));
                i.remove();
                continue;
            }
            Collection counters = (Collection)catValue;
            Iterator j = counters.iterator();
            while (j.hasNext()) {
                String[] counter = (String[])j.next();
                if (pSelectedNames.contains(counter[0])) continue;
                j.remove();
            }
            if (pSelectedCounters.containsKey(catName) && !counters.isEmpty()) continue;
            logger.debug((Object)("Pruning 2: " + catName));
            i.remove();
        }
    }

    private void pruneEmptyCategories(Map pCategoryHash, Map pSelectedCounters) {
        Vector orphanCounters = new Vector();
        Iterator i = pCategoryHash.keySet().iterator();
        while (i.hasNext()) {
            String catName = (String)i.next();
            Object catValue = pCategoryHash.get(catName);
            if (catValue instanceof Map) {
                Map catValueHash = (Map)catValue;
                this.pruneEmptyCategories(catValueHash, pSelectedCounters);
                if (!catValueHash.isEmpty()) continue;
                logger.debug((Object)("Pruning empty category: " + catName));
                i.remove();
                continue;
            }
            Collection counters = (Collection)catValue;
            Collection instances = (Collection)pSelectedCounters.get(catName);
            if (instances == null || !instances.isEmpty()) continue;
            orphanCounters.addAll(counters);
            i.remove();
        }
        if (!orphanCounters.isEmpty()) {
            pCategoryHash.put("{leafs}", orphanCounters);
        }
    }

    private void inflateInstances(Map pCategoryHash, Map pInstances, Map pOids) {
        LinkedHashMap toAdd = new LinkedHashMap();
        Iterator i = pCategoryHash.keySet().iterator();
        while (i.hasNext()) {
            String catName = (String)i.next();
            Object catValue = pCategoryHash.get(catName);
            if (catValue instanceof Map) {
                this.inflateInstances((Map)catValue, pInstances, pOids);
                continue;
            }
            Vector counters = (Vector)catValue;
            Collection instances = (Collection)pInstances.get(catName);
            if (!"{leafs}".equals(catName) && instances != null && !instances.isEmpty()) {
                i.remove();
                for (String instance : instances) {
                    Vector<String[]> newCounters = new Vector<String[]>(counters.size());
                    for (String[] counter : counters) {
                        String[] newCounter = new String[counter.length];
                        newCounter[0] = pOids.get(counter[0]) + "::" + catName + "::" + instance;
                        newCounter[1] = counter[0] + "::" + instance;
                        for (int l = 2; l < counter.length; ++l) {
                            newCounter[l] = counter[l];
                        }
                        newCounters.add(newCounter);
                    }
                    toAdd.put(catName + "::" + instance, newCounters);
                }
                continue;
            }
            for (String[] counter : counters) {
                counter[0] = (String)pOids.get(counter[0]) + "::" + catName;
            }
        }
        for (String key : toAdd.keySet()) {
            pCategoryHash.put(key, toAdd.get(key));
        }
    }

    public static Map getPMCollectionVariablesForME(Serializable me, String entityType, String pRoot) {
        try {
            PerformanceCollectionLookup lookup = PMCollectionEntityTypeUtil.getLookupByEntityType(entityType);
            String value = lookup.get(pRoot);
            Map ret = (Map)PerformanceCollectionViewerServiceImpl.getPMCollectionVarRecursive(lookup, me, value);
            return ret;
        }
        catch (Exception e) {
            logger.debug((Object)e, (Throwable)e);
            return null;
        }
    }

    private static Object getPMCollectionVarRecursive(PerformanceCollectionLookup lookup, Serializable me, String value) throws Exception {
        if (value == null) {
            return null;
        }
        StringTokenizer plusTokenizer = new StringTokenizer(value, "+");
        LinkedHashMap<String, Object> masterRet = new LinkedHashMap<String, Object>();
        while (plusTokenizer.hasMoreTokens()) {
            String counterName;
            StringTokenizer pipeTokenizer;
            Vector<String[]> ret;
            String catValue;
            String catName;
            String category = plusTokenizer.nextToken();
            if (category.indexOf(";") != -1) {
                StringTokenizer semiColonTokenizer = new StringTokenizer(category, ";");
                while (semiColonTokenizer.hasMoreTokens()) {
                    Object retVal;
                    String subCat = semiColonTokenizer.nextToken();
                    if (subCat.trim().length() <= 0) continue;
                    String subValue = null;
                    try {
                        subValue = lookup.get(subCat, me);
                        if (subValue == null) {
                            continue;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (null == (retVal = PerformanceCollectionViewerServiceImpl.getPMCollectionVarRecursive(lookup, me, subValue))) continue;
                    masterRet.put(subCat, retVal);
                }
                continue;
            }
            StringTokenizer colonTokenizer = new StringTokenizer(category, ":");
            int colonCount = colonTokenizer.countTokens() - 1;
            if (0 == colonCount) {
                Vector<String[]> ret2 = new Vector<String[]>();
                StringTokenizer pipeTokenizer2 = new StringTokenizer(category, "|");
                while (pipeTokenizer2.hasMoreTokens()) {
                    String counterName2 = pipeTokenizer2.nextToken();
                    ret2.add(AvPmCollectionUtil.getCounterFromToken((String)counterName2));
                }
                logger.debug((Object)("0 - returning: " + ret2));
                return ret2;
            }
            if (1 == colonCount) {
                catName = colonTokenizer.nextToken();
                catValue = colonTokenizer.nextToken();
                ret = new Vector<String[]>();
                pipeTokenizer = new StringTokenizer(catValue, "|");
                while (pipeTokenizer.hasMoreTokens()) {
                    counterName = pipeTokenizer.nextToken();
                    ret.add(AvPmCollectionUtil.getCounterFromToken((String)counterName));
                }
                logger.debug((Object)("1 - adding: " + catName + "=" + ret));
                masterRet.put(catName, ret);
                continue;
            }
            catName = colonTokenizer.nextToken();
            colonTokenizer.nextToken();
            catValue = colonTokenizer.nextToken();
            ret = new Vector();
            pipeTokenizer = new StringTokenizer(catValue, "|");
            while (pipeTokenizer.hasMoreTokens()) {
                counterName = pipeTokenizer.nextToken();
                ret.add(AvPmCollectionUtil.getCounterFromToken((String)counterName));
            }
            logger.debug((Object)("2 - adding: " + catName + "=" + ret));
            masterRet.put(catName, ret);
        }
        logger.debug((Object)("Returning: " + masterRet));
        return masterRet;
    }
}

