/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.services.impl.LockManager;
import com.bwanms.util.TimedObjectCache;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class LockManagerImpl
implements LockManager {
    private static final Logger logger = Logger.getLogger(LockManagerImpl.class);
    private LockCache lockMap;

    public void start() {
        this.lockMap = new LockCache();
    }

    public void stop() {
        this.lockMap.shutdown();
        this.lockMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock getLock(String key) {
        LockCache lockCache = this.lockMap;
        synchronized (lockCache) {
            logger.debug((Object)("Get lock [" + key + "]"));
            Lock lock = (Lock)this.lockMap.get(key);
            if (lock == null) {
                logger.debug((Object)("Create lock [" + key + "]"));
                lock = new LoggedLock(key);
                this.lockMap.put(key, lock);
            }
            return lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLock(String key) {
        LockCache lockCache = this.lockMap;
        synchronized (lockCache) {
            logger.debug((Object)("Remove lock [" + key + "]"));
            this.lockMap.remove(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LockCache
    extends TimedObjectCache<String, Lock> {
        public LockCache() {
            super("LockManagerImpl", 60L, TimeUnit.SECONDS);
        }

        @Override
        public boolean isRemovable(Lock entry) {
            boolean ret = entry.tryLock();
            if (ret) {
                entry.unlock();
            }
            return ret;
        }
    }

    private static class LoggedLock
    implements Lock {
        private ReentrantLock lock = new ReentrantLock();
        private String name;

        public LoggedLock(String name) {
            this.name = name;
        }

        public void lock() {
            logger.debug((Object)("[" + this.name + "] lock"));
            this.lock.lock();
            logger.debug((Object)("[" + this.name + "] locked"));
        }

        public void lockInterruptibly() throws InterruptedException {
            logger.debug((Object)("[" + this.name + "] lockInterruptibly"));
            this.lock.lockInterruptibly();
        }

        public boolean tryLock() {
            logger.debug((Object)("[" + this.name + "] tryLock"));
            boolean locked = this.lock.tryLock();
            if (locked) {
                logger.debug((Object)("[" + this.name + "] locked"));
            }
            return locked;
        }

        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            logger.debug((Object)("[" + this.name + "] tryLock"));
            return this.lock.tryLock(time, unit);
        }

        public void unlock() {
            logger.debug((Object)("[" + this.name + "] unlock"));
            this.lock.unlock();
        }

        public Condition newCondition() {
            logger.debug((Object)("[" + this.name + "] newCondition"));
            return this.lock.newCondition();
        }
    }
}

