/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.mediation.FileSystemService;
import com.bwanms.mediation.filesystem.FileSystemFileInputStream;
import com.bwanms.model.license.License;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.LicenseAlreadyImportedException;
import com.bwanms.services.LicenseService;
import com.bwanms.services.ServiceException;
import com.bwanms.util.ExecutorUtils;
import com.bwanms.util.IOUtil;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class LicenseServiceImpl
implements LicenseService {
    private static final Logger logger = Logger.getLogger(LicenseServiceImpl.class);
    private ScheduledExecutorService executor;
    private FileSystemService fileSystemService;

    public void start() {
        PlatformFactory.getApplicationLayerPlatform().getMessaging().createTopic("topic/ActiveLicenseID");
        PlatformFactory.getApplicationLayerPlatform().getMessaging().createTopic("topic/ActiveLicenseFeature");
        this.fileSystemService = (FileSystemService)PlatformFactory.getMediationLayerPlatform(null).getLookup().lookup("bwanms/mediation/FileSystem");
        this.executor = Executors.newScheduledThreadPool(1);
        this.executor.scheduleAtFixedRate(new LicenseScannerRunnable(), 0L, 300L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.fileSystemService = null;
        PlatformFactory.getApplicationLayerPlatform().getMessaging().destroyTopic("topic/ActiveLicenseID");
        PlatformFactory.getApplicationLayerPlatform().getMessaging().destroyTopic("topic/ActiveLicenseFeature");
        ExecutorUtils.shutdownAndWait("LicenseService", this.executor);
    }

    public License addLicense(byte[] licenseFile) throws ServiceException {
        LicenseAddRunnable addLicense = new LicenseAddRunnable(licenseFile);
        return addLicense.getLicense();
    }

    private class LicenseAddRunnable
    implements Runnable {
        private License license;
        private byte[] licenseFile;
        private ServiceException licenseException;

        public LicenseAddRunnable(byte[] licenseFile) {
            this.licenseFile = licenseFile;
        }

        public void run() {
            new RunnableDatastoreDecorator(new Runnable(){

                public void run() {
                    try {
                        LicenseAddRunnable.this.license = LicenseHelper.importLicense(LicenseAddRunnable.this.licenseFile);
                        LicenseHelper.licenseCheck();
                    }
                    catch (ServiceException e) {
                        LicenseAddRunnable.this.licenseException = e;
                    }
                }
            }).run();
        }

        public License getLicense() throws ServiceException {
            if (this.licenseException != null) {
                throw this.licenseException;
            }
            return this.license;
        }
    }

    private class LicenseScannerRunnable
    implements Runnable {
        private LicenseScannerRunnable() {
        }

        public void run() {
            new RunnableDatastoreDecorator(new Runnable(){

                public void run() {
                    LicenseScannerRunnable.this.runInternal();
                }
            }).run();
        }

        private void runInternal() {
            try {
                String[] licenseFiles;
                for (String licenseFileName : licenseFiles = LicenseServiceImpl.this.fileSystemService.listFiles("license")) {
                    logger.debug((Object)("Importing license: " + licenseFileName));
                    try {
                        FileSystemFileInputStream in = new FileSystemFileInputStream(LicenseServiceImpl.this.fileSystemService, licenseFileName);
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        IOUtil.copyStream(in, out, 2048);
                        in.close();
                        out.close();
                        LicenseHelper.importLicense(out.toByteArray());
                    }
                    catch (LicenseAlreadyImportedException aie) {
                        logger.debug((Object)("Already imported: " + licenseFileName));
                    }
                    catch (ServiceException e) {
                        logger.debug((Object)"Error importing license", (Throwable)e);
                    }
                }
            }
            catch (Throwable e) {
                logger.warn((Object)"Error accessing license folder: ", e);
            }
            LicenseHelper.licenseCheck();
        }
    }
}

