/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.model.license.License;
import com.bwanms.model.license.LicensingInfo;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.PrivateSessionManager;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.LicenseManagerService;
import com.bwanms.services.ServiceException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseManagerServiceImpl
implements LicenseManagerService {
    private static final Logger log = Logger.getLogger(LicenseManagerServiceImpl.class);

    @Override
    public License addLicense(byte[] licenseFile) throws ServiceException {
        License license = LicenseHelper.importLicense(licenseFile);
        return license;
    }

    @Override
    public void deleteLicense(long licenseId) throws ServiceException {
        License license = (License)Datastore.session().get(License.class, (Serializable)new Long(licenseId));
        if (license == null) {
            throw new ServiceException("License does not exist");
        }
        license.markDeleted();
    }

    @Override
    public void activateLicense(long licenseId) throws ServiceException {
        Session session = PrivateSessionManager.privateSession();
        List<License> licenses = LicenseHelper.getLicenses(session);
        long oldId = licenseId;
        for (License lic : licenses) {
            if (lic.isActive()) {
                oldId = lic.getId();
                lic.setActive(false);
            }
            if (lic.getId() != licenseId) continue;
            lic.setActive(true);
        }
        try {
            PrivateSessionManager.commit(session);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ServiceException(e);
        }
        try {
            LicenseHelper.resetLicenseFeaturesWithLicenseId(session, oldId);
            LicenseHelper.retrieveActiveLicense();
            PlatformFactory.getApplicationLayerPlatform().getMessaging().publish("topic/ActiveLicenseID", new Long(licenseId));
            PlatformFactory.getApplicationLayerPlatform().getMessaging().publish("topic/ActiveLicenseFeature", LicenseHelper.getActiveLicenseFeature());
            LicenseHelper.licenseAllNotLicensedEquipments(session, licenseId);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ServiceException(e);
        }
        finally {
            session.close();
        }
    }

    @Override
    public Long getActiveLicense() throws ServiceException {
        return LicenseHelper.getActiveLicense();
    }

    @Override
    public ArrayList<String> getActiveLicenseFeature() throws ServiceException {
        return LicenseHelper.getActiveLicenseFeature();
    }

    @Override
    public LicensingInfo getLicensingInfo() throws ServiceException {
        return new LicensingInfo();
    }
}

