/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.mo.EquipmentConfiguration;
import com.bwanms.model.Equipment;
import com.bwanms.model.EquipmentManager;
import com.bwanms.model.Locatable;
import com.bwanms.model.Location;
import com.bwanms.model.ManagedEquipment;
import com.bwanms.model.license.Licensable;
import com.bwanms.persistence.Datastore;
import com.bwanms.services.EntityNotFoundException;
import com.bwanms.services.InventoryManagementService;
import com.bwanms.services.ServiceException;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class InventoryManagementServiceImpl
implements InventoryManagementService {
    private static final Logger logger = Logger.getLogger(InventoryManagementServiceImpl.class);

    private Equipment forceReadAllChildren(Equipment equipment, final boolean hack) {
        logger.info((Object)("equipment = " + equipment));
        if (equipment == null) {
            return null;
        }
        if (!(equipment instanceof EquipmentManager)) {
            return equipment;
        }
        new Object(){

            public void find(EquipmentManager eq) {
                for (ManagedEquipment child : eq.findManagedEquipment()) {
                    Location location;
                    if (child instanceof EquipmentManager) {
                        this.find((EquipmentManager)((Object)child));
                    }
                    if (!hack || !(child instanceof Locatable) || null == (location = ((Locatable)((Object)child)).getLocation())) continue;
                    Datastore.session().evict((Object)location);
                    location.setParent(null);
                }
            }
        }.find((EquipmentManager)((Object)equipment));
        return equipment;
    }

    public EquipmentConfiguration findFullCurrentConfiguration(String equipmentEUID) {
        EquipmentConfiguration existing = (EquipmentConfiguration)Datastore.session().createQuery("from EquipmentConfiguration cfg where (cfg.equipment.EUID=?)").setString(0, equipmentEUID).uniqueResult();
        existing.getNetworkResources().size();
        this.forceReadAllChildren(existing.getEquipment(), false);
        return existing;
    }

    public boolean licenseEquipment(long equipmentId) throws ServiceException {
        Equipment eq = (Equipment)Datastore.session().get(Equipment.class, (Serializable)Long.valueOf(equipmentId));
        if (eq == null) {
            throw new EntityNotFoundException("Could not find Equipment [" + equipmentId + "]");
        }
        if (!(eq instanceof Licensable)) {
            throw new ServiceException("Equipment is not licensable");
        }
        return LicenseHelper.licenseEntity((Licensable)((Object)eq));
    }

    public void unlicenseEquipment(long equipmentId) throws ServiceException {
        Equipment eq = (Equipment)Datastore.session().get(Equipment.class, (Serializable)Long.valueOf(equipmentId));
        if (eq == null) {
            throw new EntityNotFoundException("Could not find Equipment [" + equipmentId + "]");
        }
        if (!(eq instanceof Licensable)) {
            throw new ServiceException("Equipment is not licensable");
        }
        LicenseHelper.unlicenseEntity((Licensable)((Object)eq));
    }
}

