/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.ddi.DDInterface;
import com.bwanms.ddi.DDRegistry;
import com.bwanms.domain.logic.Helpers;
import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.model.Equipment;
import com.bwanms.model.ManagedEntity;
import com.bwanms.model.ObjectID;
import com.bwanms.model.fault.Event;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.persistence.Datastore;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.PollingLevel;
import com.bwanms.services.SynchronizationCandidateProvider;
import com.bwanms.services.impl.LockManagerLocator;
import com.bwanms.services.impl.ManagedEntityCachedState;
import com.bwanms.services.impl.ManagedEntityStateManager;
import com.bwanms.util.ExecutorUtils;
import com.bwanms.util.NamedThreadFactory;
import com.bwanms.util.Settings;
import com.bwanms.util.SynchronizationCandidateProviderUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquipmentStateManagerImpl
implements ManagedEntityStateManager {
    private static final Logger log = Logger.getLogger(EquipmentStateManagerImpl.class);
    private static final int POLLING_LEVELS = 2;
    private static boolean pollingDisabled = "true".equals(System.getProperty("com.bwanms.noPolling", "false"));
    private ScheduledExecutorService[] pollingSchedulers;
    private ExecutorService pollingWorkers;
    private LinkedBlockingQueue<ObjectID> synchQueue;
    private boolean shouldStop = false;
    private boolean systemUp = false;

    public EquipmentStateManagerImpl() {
        this.configure();
    }

    public void configure() {
        log.debug((Object)"configure EquipmentStateManagerService");
        PlatformFactory.getApplicationLayerPlatform().getMessaging().createTopic("topic/EquipmentState");
        this.synchQueue = new LinkedBlockingQueue();
        this.shouldStop = false;
        if (this.systemUp) {
            this.initializePolling();
        } else {
            PlatformFactory.getApplicationLayerPlatform().getMessaging().addTopicListener("topic/Platform", new MessageListener(){

                public void onMessage(Message msg) {
                    if (!EquipmentStateManagerImpl.this.systemUp) {
                        EquipmentStateManagerImpl.this.systemUp = true;
                        EquipmentStateManagerImpl.this.initializePolling();
                    }
                }
            });
        }
    }

    private void initializePolling() {
        int levelCount = PollingLevel.values().length;
        this.pollingSchedulers = new ScheduledExecutorService[levelCount];
        this.pollingWorkers = Executors.newCachedThreadPool(new NamedThreadFactory("PollingWorkers"));
        for (PollingLevel pollingLevel : PollingLevel.values()) {
            int level = pollingLevel.getLevel();
            int i = pollingLevel.ordinal();
            NamedThreadFactory threadFactory = new NamedThreadFactory(this.getClass().getName() + ".level-" + level);
            this.pollingSchedulers[i] = Executors.newScheduledThreadPool(1, threadFactory);
            for (int j = 0; j < Settings.instance().getPollingServiceMaximumThreads(); ++j) {
                this.pollingWorkers.execute(new SynchronizationWorker());
            }
            long period = Settings.instance().getPollingServiceReachableSynchronizationPeriod();
            if (PollingLevel.Level1 == pollingLevel) {
                period = Settings.instance().getPollingServiceUnreachableSynchronizationPeriod();
            }
            this.pollingSchedulers[i].scheduleAtFixedRate(new PollingRunnable(pollingLevel), 0L, period, TimeUnit.MILLISECONDS);
        }
    }

    public void end() {
        PlatformFactory.getApplicationLayerPlatform().getMessaging().destroyTopic("topic/EquipmentState");
        this.shutdownPolling();
    }

    public void shutdownPolling() {
        if (this.pollingSchedulers != null) {
            for (int i = 0; i < 2; ++i) {
                ExecutorUtils.shutdownAndWait("PollingScheduler-level-" + i, this.pollingSchedulers[i]);
            }
            this.shouldStop = true;
            ExecutorUtils.shutdownAndWait("PollingWorkers", this.pollingWorkers);
        }
    }

    @Override
    public void compatibleManagedEntityCreated(ManagedEntity entity) {
        this.syncNow((Equipment)entity);
    }

    @Override
    public void compatibleManagedEntityRemoved(long managedEntityId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleSync(Equipment equipment) {
        if (pollingDisabled) {
            return;
        }
        LinkedBlockingQueue<ObjectID> linkedBlockingQueue = this.synchQueue;
        synchronized (linkedBlockingQueue) {
            ObjectID equipmentId = new ObjectID(equipment.getClass().getName(), Long.valueOf(equipment.getId()));
            if (!this.synchQueue.contains(equipmentId)) {
                try {
                    this.synchQueue.put(equipmentId);
                }
                catch (InterruptedException e) {
                    log.debug((Object)"", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void entityEventsProcessed(ManagedEntity entity, List<Event> events) {
    }

    @Override
    public void syncNow(Equipment equipment) {
        this.scheduleSync(equipment);
    }

    private List<? extends Equipment> getCandidates(PollingLevel level) {
        ArrayList<? extends Equipment> candidates = new ArrayList<Equipment>();
        List<SynchronizationCandidateProvider> providers = SynchronizationCandidateProviderUtil.getProviders();
        for (SynchronizationCandidateProvider provider : providers) {
            List<? extends Equipment> currentCandidates = provider.getCandidates(level);
            if (currentCandidates == null || currentCandidates.isEmpty()) continue;
            candidates.addAll(currentCandidates);
        }
        return candidates;
    }

    @Override
    public void initializeManagedEntityState(ManagedEntity entity, ManagedEntityCachedState entityState) {
        entityState.setState(((Equipment)entity).getState());
    }

    private class PollingRunnable
    implements Runnable {
        private final PollingLevel level;

        public PollingRunnable(PollingLevel level) {
            this.level = level;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            log.debug((Object)("PollingRunnable.run() - " + (Object)((Object)this.level)));
            final ArrayList equipments = new ArrayList();
            try {
                new CallableDatastoreDecorator<Object>(new Callable<Object>(){

                    @Override
                    public Object call() {
                        equipments.addAll(EquipmentStateManagerImpl.this.getCandidates(PollingRunnable.this.level));
                        log.debug((Object)("Got: " + equipments.size() + " candidates for " + PollingRunnable.this.level.name()));
                        return null;
                    }
                }).call();
                for (Equipment eq : equipments) {
                    EquipmentStateManagerImpl.this.scheduleSync(eq);
                }
                LinkedBlockingQueue i$ = EquipmentStateManagerImpl.this.synchQueue;
                synchronized (i$) {
                    log.debug((Object)(EquipmentStateManagerImpl.this.synchQueue.size() + " equipments scheduled for synch"));
                }
            }
            catch (Throwable t) {
                log.error((Object)t, t);
            }
        }
    }

    private class SynchronizationWorker
    implements Runnable {
        private Equipment targetEquipment = null;

        private SynchronizationWorker() {
        }

        public void run() {
            while (!EquipmentStateManagerImpl.this.shouldStop) {
                try {
                    final ObjectID equipmentOID = (ObjectID)EquipmentStateManagerImpl.this.synchQueue.take();
                    final Long equipmentId = (long)((Long)equipmentOID.getIdentifier());
                    new CallableDatastoreDecorator<Object>(new Callable<Object>(){

                        @Override
                        public Object call() {
                            SynchronizationWorker.this.targetEquipment = (Equipment)Datastore.session().get(equipmentOID.getClassName(), (Serializable)new Long(equipmentId));
                            if (SynchronizationWorker.this.targetEquipment == null) {
                                log.debug((Object)("Equipment was deleted: " + equipmentId));
                                return null;
                            }
                            if (!LicenseHelper.isLicensed(SynchronizationWorker.this.targetEquipment)) {
                                log.debug((Object)("Equipment is unlicensed: " + equipmentId));
                                SynchronizationWorker.this.targetEquipment = null;
                                return null;
                            }
                            return null;
                        }
                    }).call();
                    this.attemptToSynchronize();
                }
                catch (InterruptedException e) {
                    log.error((Object)e, (Throwable)e);
                }
                catch (Throwable t) {
                    log.debug((Object)"", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void attemptToSynchronize() {
            block10: {
                if (null == this.targetEquipment) {
                    return;
                }
                long equipmentId = this.targetEquipment.getId();
                Lock syncLock = LockManagerLocator.locate().getLock(Equipment.getSynchronizationLockKey(equipmentId));
                try {
                    if (syncLock.tryLock(500L, TimeUnit.MILLISECONDS)) {
                        log.debug((Object)("Executing sync: " + equipmentId));
                        try {
                            DDInterface ddi = DDRegistry.getInstance().getDDInterfaceByEquipmentClass(this.targetEquipment.getClass().getName());
                            if (ddi == null) {
                                throw new RuntimeException("Can't determine DDInterface for equipment type: " + this.targetEquipment.getClass().getName());
                            }
                            ddi.getSynchronizationStrategy(this.targetEquipment, Helpers.getDDCallback()).synchronizeState();
                            break block10;
                        }
                        catch (Throwable t) {
                            log.debug((Object)t, t);
                            break block10;
                        }
                        finally {
                            syncLock.unlock();
                        }
                    }
                    log.debug((Object)("Already running: " + equipmentId));
                }
                catch (InterruptedException e) {
                    log.debug((Object)("Interrupted while waiting for lock: " + equipmentId));
                }
            }
        }
    }
}

