/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.ddi.DDRegistry;
import com.bwanms.domain.logic.Helpers;
import com.bwanms.domain.logic.SystemEntityEvents;
import com.bwanms.mediation.util.EventFacade;
import com.bwanms.model.Equipment;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.ServiceTransactionManagementInterceptor;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.impl.EquipmentCommunicationHandler;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;

public class EquipmentCommunicationHandlerImpl
implements EquipmentCommunicationHandler {
    private static final Logger log = Logger.getLogger(EquipmentCommunicationHandlerImpl.class);
    private MessageListener communicationListener;

    public EquipmentCommunicationHandlerImpl() {
        PlatformFactory.getApplicationLayerPlatform().getMessaging().createQueue("queue/EquipmentStateComm");
    }

    public void start() {
        PlatformFactory.getApplicationLayerPlatform().getMessaging().setQueueListener("queue/EquipmentStateComm", this.getEquipmentCommunicationListener());
    }

    public void stop() {
        PlatformFactory.getApplicationLayerPlatform().getMessaging().removeQueueListener(this.communicationListener);
        this.communicationListener = null;
    }

    private MessageListener getEquipmentCommunicationListener() {
        this.communicationListener = (MessageListener)ServiceTransactionManagementInterceptor.install(new EquipmentCommunicationListener(), MessageListener.class);
        return this.communicationListener;
    }

    private void handleCommunicationEvent(EquipmentCommunicationEvent event) {
        if (event.getEventType() == 0) {
            this.handleCommunicationOK(event.getEquipmentId());
        } else {
            this.handleCommunicationError(event.getEquipmentId());
        }
    }

    private void handleCommunicationError(long equipmentId) {
        log.debug((Object)("Comm ERROR: " + equipmentId));
        Equipment eq = (Equipment)Datastore.session().get(Equipment.class, (Serializable)new Long(equipmentId));
        if (eq != null) {
            DDRegistry.getInstance().getDDInterfaceByEquipmentClass(eq.getClass().getName()).getSynchronizationStrategy(eq, Helpers.getDDCallback()).setUnreachable(null);
        }
    }

    private void handleCommunicationOK(long equipmentId) {
        Equipment eq = (Equipment)Datastore.session().get(Equipment.class, (Serializable)new Long(equipmentId));
        if (eq != null) {
            EventFacade.emitEvent(SystemEntityEvents.equipmentCommOk(null, eq));
        }
    }

    public static class EquipmentCommunicationEvent
    implements Serializable {
        public static final int COMMUNICATION_OK = 0;
        public static final int COMMUNICATION_ERROR = 1;
        private long equipmentId;
        private int eventType;

        public EquipmentCommunicationEvent(long equipmentId, int eventType) {
            this.equipmentId = equipmentId;
            this.eventType = eventType;
        }

        public long getEquipmentId() {
            return this.equipmentId;
        }

        public int getEventType() {
            return this.eventType;
        }
    }

    private class EquipmentCommunicationListener
    implements MessageListener {
        private EquipmentCommunicationListener() {
        }

        public void onMessage(Message msg) {
            try {
                log.debug((Object)("handleCommunicationEvent message " + msg));
                EquipmentCommunicationHandlerImpl.this.handleCommunicationEvent((EquipmentCommunicationEvent)((ObjectMessage)msg).getObject());
            }
            catch (JMSException jmse) {
                log.debug((Object)"", (Throwable)jmse);
            }
        }
    }
}

