/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.model.entity.Assemblers;
import com.bwanms.model.entity.Assembly;
import com.bwanms.model.entity.LightQuery;
import com.bwanms.model.entity.Persister;
import com.bwanms.model.entity.Persisters;
import com.bwanms.persistence.Datastore;
import com.bwanms.services.EntityManagerService;
import com.bwanms.services.EntityNotFoundException;
import com.bwanms.services.ServiceException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerServiceImpl
implements EntityManagerService {
    @Override
    public <E extends Serializable> List<E> retrieveAll(Class<E> clazz) {
        return Datastore.session().createQuery("from " + clazz.getName()).list();
    }

    @Override
    public <E extends Serializable> List<Assembly<E>> retrieveAll(Class<E> clazz, String assembler) throws ServiceException {
        ArrayList<Assembly<Assembly<Serializable>>> assemblies = new ArrayList<Assembly<Assembly<Serializable>>>();
        for (Serializable entity : this.retrieveAll(clazz)) {
            assemblies.add(Assemblers.assemble(entity, assembler));
        }
        return assemblies;
    }

    @Override
    public <E extends Serializable> List<E> retrieveByQuery(LightQuery<E> query) {
        return query.execute();
    }

    @Override
    public <E extends Serializable> List<Assembly<E>> retrieveByQuery(LightQuery<E> query, String assembler) throws ServiceException {
        ArrayList<Assembly<Assembly<Serializable>>> assemblies = new ArrayList<Assembly<Assembly<Serializable>>>();
        for (Serializable entity : this.retrieveByQuery(query)) {
            assemblies.add(Assemblers.assemble(entity, assembler));
        }
        return assemblies;
    }

    @Override
    public <E extends Serializable> E get(Class<E> clazz, long id) {
        return (E)((Serializable)Datastore.session().get(clazz, (Serializable)Long.valueOf(id)));
    }

    @Override
    public <E extends Serializable> Assembly<E> get(Class<E> clazz, long id, String assembler) throws ServiceException {
        E entity = this.get(clazz, id);
        return entity != null ? Assemblers.assemble(entity, assembler) : null;
    }

    @Override
    public <E extends Serializable> E save(E entity) throws ServiceException {
        Persister<?> persister = Persisters.getPersister(entity.getClass());
        if (persister != null) {
            persister.persistBeforeSave(entity);
        }
        try {
            Datastore.session().saveOrUpdate(entity);
        }
        catch (HibernateException e) {
            throw new ServiceException("com.bwanms.gui.editor", "EntitySaveError", e);
        }
        if (persister != null) {
            persister.persistAfterSave(entity);
        }
        return entity;
    }

    @Override
    public <E extends Serializable> void delete(E entity) throws ServiceException {
        Persister<?> persister = Persisters.getPersister(entity.getClass());
        Datastore.session().lock(entity, LockMode.NONE);
        Datastore.session().refresh(entity);
        if (persister != null) {
            persister.persistBeforeDelete(entity);
        }
        Datastore.session().delete(entity);
        if (persister != null) {
            persister.persistAfterDelete(entity);
        }
    }

    @Override
    public <E extends Serializable> void delete(Class<E> objectClass, Serializable identifier) throws ServiceException {
        Serializable entity = (Serializable)Datastore.session().get(objectClass, identifier);
        if (entity == null) {
            throw new ServiceException("com.bwanms.gui.editor.EntityEditorContainer", "EntityNotFoundMessage", new EntityNotFoundException("Entity not found"));
        }
        Persister<?> persister = Persisters.getPersister(entity.getClass());
        if (persister != null) {
            persister.persistBeforeDelete(entity);
        }
        try {
            Datastore.session().delete((Object)entity);
        }
        catch (HibernateException e) {
            throw new ServiceException("com.bwanms.gui.editor", "EntityDeleteError", e);
        }
        if (persister != null) {
            persister.persistAfterDelete(entity);
        }
    }

    @Override
    public <E extends Serializable> List<E> saveAll(List<E> list) throws ServiceException {
        for (Serializable entity : list) {
            this.save(entity);
        }
        return list;
    }

    @Override
    public <E extends Serializable> void saveOrDeleteAll(Map<E, Boolean> map) throws ServiceException {
        for (Serializable entity : map.keySet()) {
            if (map.get(entity).booleanValue()) {
                this.delete(entity);
                continue;
            }
            this.save(entity);
        }
    }

    @Override
    public void deleteAll(Class clazz) {
        Datastore.session().createQuery("delete from " + clazz.getName()).executeUpdate();
    }

    @Override
    public <E extends Serializable> void deleteAll(Collection<E> collection) throws ServiceException {
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.delete((Serializable)iterator.next());
        }
    }
}

