/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.model.fault.Event;
import com.bwanms.services.impl.EntityEventNotification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityEventNotificationBatch
implements Serializable {
    private List<EntityEventNotification> eventNotifications = new ArrayList<EntityEventNotification>();
    private transient List<Runnable> prepareRunnables = new ArrayList<Runnable>();
    private transient List<Event> events = new ArrayList<Event>();

    public int getSize() {
        return this.eventNotifications.size();
    }

    public Map<Long, List<Event>> getEventsGroupedByManagedEntityId() {
        TreeMap<Long, List<Event>> ret = new TreeMap<Long, List<Event>>();
        for (EntityEventNotification notification : this.eventNotifications) {
            List<Event> eventList = ret.get(notification.getManagedEntityId());
            if (eventList == null) {
                eventList = new ArrayList<Event>();
                ret.put(notification.getManagedEntityId(), eventList);
            }
            eventList.add(notification.getEntityEvent());
        }
        return ret;
    }

    public void addEntityEventNotification(Event event, Runnable prepareRunnable) {
        this.events.add(event);
        if (prepareRunnable != null) {
            this.prepareRunnables.add(prepareRunnable);
        }
    }

    public void prepare() {
        for (Runnable prepareRunnable : this.prepareRunnables) {
            prepareRunnable.run();
        }
        for (Event event : this.events) {
            this.processEntityEvent(event);
        }
        this.prepareRunnables.clear();
        this.events.clear();
    }

    public void processEntityEvent(Event event) {
        EntityEventNotification notification = new EntityEventNotification(event);
        this.eventNotifications.add(notification);
    }
}

