/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.domain.logic.Helpers;
import com.bwanms.gui.configuration.EquipmentManagerNotFoundException;
import com.bwanms.mediation.AgentException;
import com.bwanms.mediation.CommunicationException;
import com.bwanms.mediation.MediationException;
import com.bwanms.mo.EquipmentConfiguration;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.NetworkDomainObject;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.model.ConfigurationErrorHandler;
import com.bwanms.model.Equipment;
import com.bwanms.services.ConfigurationService;
import com.bwanms.services.EntityNotFoundException;
import com.bwanms.services.EquipmentAgentException;
import com.bwanms.services.EquipmentCommunicationException;
import com.bwanms.services.ServiceException;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.util.ConfigurationPluginUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationServiceImpl
implements ConfigurationService {
    private static final Logger logger = Logger.getLogger(ConfigurationServiceImpl.class);

    @Override
    public List<ManagedObject> retrieveCurrentConfiguration(long equipmentId, String networkResourceConfiguratioName, List<Class<? extends ManagedObject>> moClasses, boolean forceRefresh) throws ServiceException {
        try {
            Equipment eq = Helpers.getConfigurationHelper().findEquipment(equipmentId);
            if (eq == null) {
                throw new EntityNotFoundException();
            }
            List<ManagedObject> managedObjects = Helpers.getConfigurationHelper().retrieveCurrentConfiguration(equipmentId, networkResourceConfiguratioName, moClasses, forceRefresh);
            ArrayList<ManagedObject> clones = new ArrayList<ManagedObject>();
            for (ManagedObject mo : managedObjects) {
                clones.add(mo.clone());
            }
            return clones;
        }
        catch (EquipmentManagerNotFoundException emnfe) {
            throw emnfe;
        }
        catch (EntityNotFoundException e) {
            throw e;
        }
        catch (CommunicationException e) {
            logger.debug((Object)"Implement me!");
            throw new EquipmentCommunicationException(e);
        }
        catch (AgentException e) {
            throw new EquipmentAgentException(e);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void updateCurrentConfiguration(long equipmentId, List<ManagedObject> mos) throws ServiceException {
        Equipment eq = null;
        try {
            eq = Helpers.getConfigurationHelper().findEquipment(equipmentId);
            if (eq == null) {
                throw new EntityNotFoundException();
            }
            Helpers.getConfigurationHelper().updateCurrentConfiguration(equipmentId, mos);
        }
        catch (EntityNotFoundException e) {
            throw e;
        }
        catch (CommunicationException e) {
            throw new EquipmentCommunicationException(e);
        }
        catch (AgentException e) {
            throw this.processAgentException(e, eq);
        }
        catch (MediationException e) {
            if (e.getCause() instanceof AgentException) {
                throw this.processAgentException((AgentException)e.getCause(), eq);
            }
            throw new EquipmentCommunicationException(e);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new ServiceException(e);
        }
    }

    @Override
    public List<Object> retrieveData(long equipmentId, List<Class> objectClasses) throws ServiceException {
        try {
            return Helpers.getConfigurationHelper().retrieveData(equipmentId, objectClasses);
        }
        catch (EquipmentManagerNotFoundException emnfe) {
            throw emnfe;
        }
        catch (CommunicationException e) {
            logger.debug((Object)"Implement me!", (Throwable)e);
            throw new EquipmentCommunicationException(e);
        }
        catch (AgentException e) {
            throw new EquipmentAgentException(e);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void sendData(long equipmentId, List<Object> data) throws ServiceException {
        Equipment eq = null;
        try {
            eq = Helpers.getConfigurationHelper().findEquipment(equipmentId);
            if (eq == null) {
                throw new EntityNotFoundException();
            }
            Helpers.getConfigurationHelper().sendData(equipmentId, data);
        }
        catch (CommunicationException e) {
            throw new EquipmentCommunicationException(e);
        }
        catch (AgentException e) {
            throw this.processAgentException(e, eq);
        }
        catch (MediationException e) {
            throw new EquipmentAgentException(e);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public <M extends ManagedObject> UnifiedMOSupport<M> retrieveCurrentConfiguration(UnifiedMORequest moRequest, boolean forceRefresh) throws ServiceException {
        List<?> managedObjects = this.retrieveCurrentConfiguration(moRequest.getEquipmentId(), moRequest.getNetworkResource(), moRequest.getMoClass(), moRequest.getInstanceQuery(), forceRefresh);
        Equipment eq = Helpers.getConfigurationHelper().findEquipment(moRequest.getEquipmentId());
        EquipmentConfiguration configuration = eq.findCurrentConfiguration();
        NetworkResourceConfiguration nrConfig = configuration.findNetworkResourceConfiguration(moRequest.getNetworkResource());
        UnifiedMOSupport moSupport = new UnifiedMOSupport(moRequest.getMoClass(), managedObjects);
        moSupport.setNRConfiguration(nrConfig);
        return moSupport;
    }

    @Override
    public <M extends ManagedObject> List<M> retrieveCurrentConfiguration(long equipmentId, String networkResource, Class<M> moClass, String instanceQuery, boolean forceRefresh) throws ServiceException {
        try {
            return Helpers.getConfigurationHelper().retrieveCurrentConfiguration(equipmentId, networkResource, moClass, instanceQuery, forceRefresh);
        }
        catch (CommunicationException e) {
            logger.debug((Object)"Implement me!", (Throwable)e);
            throw new EquipmentCommunicationException(e);
        }
        catch (AgentException e) {
            throw new EquipmentAgentException(e);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public <N extends NetworkDomainObject> List<N> retrieveData(long equipmentId, String networkResource, Class<N> ndoClass, String instanceQuery) throws ServiceException {
        try {
            return Helpers.getConfigurationHelper().retrieveData(equipmentId, networkResource, ndoClass, instanceQuery);
        }
        catch (CommunicationException e) {
            logger.debug((Object)"Implement me!", (Throwable)e);
            throw new EquipmentCommunicationException(e);
        }
        catch (AgentException e) {
            throw new EquipmentAgentException(e);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    private EquipmentAgentException processAgentException(AgentException exception, Equipment equipment) {
        for (ConfigurationErrorHandler handler : ConfigurationPluginUtil.getInstance().getConfigErrorHandlers()) {
            if (!handler.accept(equipment)) continue;
            return handler.handleConfigError(exception, equipment);
        }
        return new EquipmentAgentException(exception);
    }
}

