/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.model.AuditLogEntry;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.PrivateSessionHelper;
import com.bwanms.security.Security;
import com.bwanms.services.AuditLogsService;
import java.util.Date;

public class AuditLogsServiceImpl
implements AuditLogsService {
    public void addAuditLogEntryInCurrentSession(String action, String category, String targetEntity, String entityType) {
        this.addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), action, category, targetEntity, entityType);
    }

    public void addAuditLogEntryInCurrentSession(String userId, String action, String category, String targetEntity, String entityType) {
        AuditLogEntry auditLogEntry = this.createAuditLogEntry(userId, action, category, targetEntity, entityType);
        Datastore.session().save((Object)auditLogEntry);
    }

    public void addAuditLogEntryInNewSession(String action, String category, String targetEntity, String entityType) {
        this.addAuditLogEntryInNewSession(Security.getSecurity().getCurrentUserId(), action, category, targetEntity, entityType);
    }

    public void addAuditLogEntryInNewSession(String userId, String action, String category, String targetEntity, String entityType) {
        AuditLogEntry logEntry = this.createAuditLogEntry(userId, action, category, targetEntity, entityType);
        PrivateSessionHelper.persistAndCommit((Object)logEntry);
    }

    private AuditLogEntry createAuditLogEntry(String userId, String action, String category, String targetEntity, String entityType) {
        AuditLogEntry auditLogEntry = new AuditLogEntry();
        auditLogEntry.setEventTime(new Date().getTime());
        if (userId.equals("OWPublic")) {
            userId = "SYSTEM";
        }
        auditLogEntry.setUserId(userId);
        auditLogEntry.setAction(action);
        auditLogEntry.setCategory(category);
        auditLogEntry.setTargetEntity(targetEntity);
        auditLogEntry.setEntityType(entityType);
        return auditLogEntry;
    }
}

