/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.model.Task;
import com.bwanms.model.TaskExecutionContext;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.TaskObserver;
import com.bwanms.model.TaskRunResult;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.model.TaskSchedule;
import com.bwanms.model.task.PerformanceCollectionGenericTask;
import com.bwanms.persistence.PrivateSessionHelper;
import com.bwanms.persistence.PrivateSessionManager;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.security.Security;
import com.bwanms.services.ActiveTaskManager;
import com.bwanms.services.SchedulerService;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.tasks.pmcollection.PMCollectionTaskExecutor;
import com.bwanms.tasks.pmcollection.SignalAction;
import com.bwanms.util.TimedObjectCache;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveTaskManagerImpl
implements ActiveTaskManager,
TaskObserver {
    private static final Logger log = Logger.getLogger(ActiveTaskManagerImpl.class);
    private Map<Long, TaskExecutionContextImpl> activeTasks = new Hashtable<Long, TaskExecutionContextImpl>();
    private TimedObjectCache<Long, TaskExecutionContextImpl> finishedTasks = new TimedObjectCache("finishedTasks", 300L, TimeUnit.SECONDS);
    private Map<String, VolatileTaskExecutionContextImpl> activeVolatileTasks = new Hashtable<String, VolatileTaskExecutionContextImpl>();
    private TimedObjectCache<String, VolatileTaskExecutionContextImpl> finishedVolatileTasks = new TimedObjectCache("finishedTasks", 300L, TimeUnit.SECONDS);
    private Set<String> userSessions = new HashSet<String>();

    public ActiveTaskManagerImpl() {
        PlatformFactory.getApplicationLayerPlatform().getMessaging().createTopic("topic/TaskObserverTopic");
        log.info((Object)"--------------------------");
        ArrayList<Long> tasksToStart = new ArrayList<Long>();
        Session session = null;
        try {
            session = PrivateSessionManager.privateSession();
            List tasks = session.createQuery("from " + Task.class.getName()).list();
            for (Task task : tasks) {
                if (task.getState() == 2 && PerformanceCollectionGenericTask.class.isAssignableFrom(task.getClass())) {
                    tasksToStart.add(task.getId());
                }
                task.setState(0);
            }
            PrivateSessionManager.commit(session);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        this.startTasks(tasksToStart);
    }

    public void cleanup() {
        PlatformFactory.getApplicationLayerPlatform().getMessaging().destroyTopic("topic/TaskObserverTopic");
        this.finishedTasks.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskStateChanged(Task task) {
        ActiveTaskManagerImpl activeTaskManagerImpl = this;
        synchronized (activeTaskManagerImpl) {
            log.debug((Object)"********** TASK STATE CHANGED **********");
            if (task.getState() == 0 && this.activeTasks.get(task.getId()) != null) {
                this.finishedTasks.put(task.getId(), this.activeTasks.remove(task.getId()));
            }
        }
        if (task.getSchedule() != null) {
            TaskSchedule schedule = task.getSchedule();
            SchedulerService service = (SchedulerService)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("bwanms/SchedulerService");
            Date nextRun = service.getNextFireTime(schedule.getId());
            schedule.setNextRun(nextRun);
            if (null == nextRun) {
                service.stopSchedule(schedule);
                task.setSchedule(null);
                PrivateSessionHelper.deleteAndCommit(schedule);
            } else {
                PrivateSessionHelper.persistAndCommit((Object)task.getSchedule());
            }
        }
        PlatformFactory.getApplicationLayerPlatform().getMessaging().publish("topic/TaskObserverTopic", task);
    }

    private void startTasks(List<Long> ids) {
        for (Long id : ids) {
            this.startTask(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startTask(long taskID) {
        TaskExecutionContextImpl exec = this.activeTasks.get(taskID);
        if (exec != null) {
            Task task = (Task)PrivateSessionHelper.getAndCloseSession(Task.class, taskID);
            this.taskStateChanged(task);
            log.warn((Object)"Task already running !");
            return;
        }
        Task task = (Task)PrivateSessionHelper.getAndCloseSession(Task.class, taskID);
        final TaskExecutionContextImpl executionCtx = new TaskExecutionContextImpl(task);
        log.debug((Object)("TASK " + taskID + " IS STARTING..."));
        ActiveTaskManagerImpl activeTaskManagerImpl = this;
        synchronized (activeTaskManagerImpl) {
            this.activeTasks.put(task.getId(), executionCtx);
        }
        new Thread(new Runnable(){

            public void run() {
                executionCtx.run(ActiveTaskManagerImpl.this);
            }
        }, task.getClass().getName() + ".startTask").start();
    }

    @Override
    public synchronized void stopTask(long taskID) {
        TaskExecutionContextImpl exec = this.activeTasks.get(taskID);
        if (exec == null || exec.getTaskState() != 2) {
            log.warn((Object)"Task is not running !");
            return;
        }
        log.debug((Object)("Stopping task " + exec.getTaskId()));
        exec.stop();
    }

    @Override
    public synchronized void deleteTask(long taskID) {
        log.info((Object)(" ------------------------------ DELETE TASK " + taskID));
        TaskExecutionContextImpl exec = this.activeTasks.get(taskID);
        if (exec != null) {
            log.warn((Object)"Task is not stopped !");
            return;
        }
        Task task = (Task)PrivateSessionHelper.getAndCloseSession(Task.class, taskID);
        if (task.getSchedule() != null) {
            SchedulerService service = (SchedulerService)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("bwanms/SchedulerService");
            TaskSchedule schedule = task.getSchedule();
            service.stopSchedule(schedule);
            task.setSchedule(null);
            PrivateSessionHelper.deleteAndCommit(schedule, task);
        } else {
            PrivateSessionHelper.deleteAndCommit(task);
        }
        task.setState(3);
        this.taskStateChanged(task);
        log.info((Object)(" ------------------------------ DELETED TASK " + taskID));
    }

    @Override
    public TaskRuntimeStatus getTaskRuntimeStatus(long taskID, Object clientData) {
        TaskExecutionContextImpl exec = this.activeTasks.get(taskID);
        try {
            if (exec != null) {
                return exec.getRuntimeStatus(clientData);
            }
            TaskRuntimeStatus status = this.finishedTasks.get(taskID).getRuntimeStatus(clientData);
            status.setFinished(true);
            return status;
        }
        catch (Exception ex) {
            log.error((Object)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String startVolatileTask(Task task) {
        String userId = this.generateUserId();
        final VolatileTaskExecutionContextImpl executionCtx = new VolatileTaskExecutionContextImpl(task, userId);
        log.debug((Object)("VOLATILE TASK " + task.getClass().getName() + " IS STARTING..."));
        ActiveTaskManagerImpl activeTaskManagerImpl = this;
        synchronized (activeTaskManagerImpl) {
            this.activeVolatileTasks.put(userId, executionCtx);
        }
        new Thread(new Runnable(){

            public void run() {
                executionCtx.run(ActiveTaskManagerImpl.this);
            }
        }, task.getClass().getName() + ".startTask").start();
        return userId;
    }

    @Override
    public synchronized void stopVolatileTask(String userId) {
        VolatileTaskExecutionContextImpl exec = this.activeVolatileTasks.get(userId);
        if (exec == null) {
            log.warn((Object)"Task is not running !");
            return;
        }
        log.debug((Object)("Stopping volatile task " + userId));
        exec.stop();
    }

    private String generateUserId() {
        StringBuilder temp;
        do {
            temp = new StringBuilder();
            temp.append("VolatileTaskUserSession").append(Math.random());
        } while (this.userSessions.contains(temp.toString()));
        this.userSessions.add(temp.toString());
        return temp.toString();
    }

    @Override
    public TaskRuntimeStatus getVolatileRuntimeStatus(String userId, Object clientData) {
        VolatileTaskExecutionContextImpl exec = this.activeVolatileTasks.get(userId);
        try {
            if (exec != null) {
                return exec.getRuntimeStatus(clientData);
            }
            TaskRuntimeStatus status = this.finishedVolatileTasks.get(userId).getRuntimeStatus(clientData);
            status.setFinished(true);
            return status;
        }
        catch (Exception ex) {
            log.error((Object)ex);
            return null;
        }
    }

    private class VolatileTaskExecutionContextImpl
    implements TaskExecutionContext {
        private Task task;
        private TaskExecutor executor;
        protected TaskRunResult taskResult = null;
        private boolean abort = false;
        private String userId;

        public VolatileTaskExecutionContextImpl(Task task, String userId) {
            this.task = task;
            this.userId = userId;
            this.taskResult = new TaskRunResult();
        }

        public final void run(TaskObserver observer) {
            this.executor = this.task.createExecutor();
            this.taskResult.setStart(System.currentTimeMillis());
            this.executor.execute(this);
        }

        public final synchronized void stop() {
            this.task.setState(1);
            this.abort = true;
        }

        public synchronized void taskFinished() {
            log.debug((Object)("******* FINISHING TASK " + this.task.getId()));
            this.task.setState(0);
            this.taskResult.setEnd(System.currentTimeMillis());
            this.taskResult.setReport(this.executor.getReport());
            this.taskResult.setTask(this.task);
            int result = this.executor.getExecutionResult();
            this.task.setLastRunResult(result);
            this.taskResult.setResult(result);
            log.debug((Object)("******* FINISHED VOLATILE TASK " + this.task.getClass().getName()));
            ActiveTaskManagerImpl.this.finishedVolatileTasks.put(this.userId, ActiveTaskManagerImpl.this.activeVolatileTasks.remove(this.userId));
            ServiceRegistry.getAuditLogsService().addAuditLogEntryInNewSession(Security.getSecurity().getCurrentUserId(), "TaskFinish", "TaskManager", this.task.getName(), this.task.getClass().getName());
        }

        public final synchronized TaskRuntimeStatus getRuntimeStatus(Object clientData) {
            return this.executor.getStatus(clientData);
        }

        public synchronized int getTaskState() {
            return this.task.getState();
        }

        public synchronized boolean shouldAbort() {
            return this.abort;
        }
    }

    private class TaskExecutionContextImpl
    implements TaskExecutionContext {
        private Task task;
        private TaskExecutor executor;
        protected TaskObserver observer;
        protected TaskRunResult taskResult = null;
        private boolean abort = false;

        public TaskExecutionContextImpl(Task task) {
            this.task = task;
            this.taskResult = new TaskRunResult();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run(TaskObserver observer) {
            TaskExecutionContextImpl taskExecutionContextImpl = this;
            synchronized (taskExecutionContextImpl) {
                if (this.getTaskState() != 0) {
                    throw new IllegalStateException("Task already running");
                }
                this.task.setState(2);
                this.task.setLastRun(System.currentTimeMillis());
                log.debug((Object)("******* STARTING TASK " + this.task.getId()));
                PrivateSessionHelper.persistAndCommit((Object)this.task);
                this.observer = observer;
            }
            observer.taskStateChanged(this.task);
            this.executor = this.task.createExecutor();
            this.taskResult.setStart(System.currentTimeMillis());
            this.executor.execute(this);
        }

        public final synchronized void stop() {
            this.task = (Task)PrivateSessionHelper.getAndCloseSession(this.task.getClass(), this.task.getId());
            if (this.getTaskState() != 2) {
                throw new IllegalStateException("Task already stopping or stopped");
            }
            this.task.setState(1);
            PrivateSessionHelper.persistAndCommit((Object)this.task);
            this.observer.taskStateChanged(this.task);
            if (this.executor instanceof PMCollectionTaskExecutor) {
                this.executor.getStatus((Object)SignalAction.ABORT);
            }
            this.abort = true;
        }

        public synchronized void taskFinished() {
            log.debug((Object)("******* FINISHING TASK " + this.task.getId()));
            this.task.setState(0);
            this.taskResult.setEnd(System.currentTimeMillis());
            this.taskResult.setReport(this.executor.getReport());
            this.taskResult.setTask(this.task);
            int result = this.executor.getExecutionResult();
            this.task.setLastRunResult(result);
            this.taskResult.setResult(result);
            PrivateSessionHelper.persistAndCommit(this.task, this.taskResult);
            log.debug((Object)("******* FINISHED TASK " + this.task.getId()));
            this.observer.taskStateChanged(this.task);
            ServiceRegistry.getAuditLogsService().addAuditLogEntryInNewSession(Security.getSecurity().getCurrentUserId(), "TaskFinish", "TaskManager", this.task.getName(), this.task.getClass().getName());
        }

        public final synchronized TaskRuntimeStatus getRuntimeStatus(Object clientData) {
            return this.executor.getStatus(clientData);
        }

        public long getTaskId() {
            return this.task.getId();
        }

        public synchronized int getTaskState() {
            return this.task.getState();
        }

        public synchronized boolean shouldAbort() {
            return this.abort;
        }
    }
}

