/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.ejb;

import com.bwanms.model.Task;
import com.bwanms.model.TaskRunResult;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.persistence.ServiceTransactionManagementInterceptor;
import com.bwanms.services.TaskManagerService;
import com.bwanms.services.impl.TaskManagerServiceImpl;
import com.bwanms.util.ServerValidationException;
import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskManagerEJBImpl
implements SessionBean {
    private static final long serialVersionUID = 2790513758617783630L;
    private transient SessionContext ctx;
    public static Logger logger = Logger.getLogger(TaskManagerEJBImpl.class);
    private TaskManagerService delegate;

    public void ejbCreate() throws EJBException, RemoteException {
        logger.debug((Object)"- ejbCreate- Creating TestServiceImpl instance");
        this.delegate = new TaskManagerServiceImpl();
        logger.debug((Object)"- ejbCreate- Installing transaction manager interceptor");
        this.delegate = (TaskManagerService)ServiceTransactionManagementInterceptor.install(this.delegate, TaskManagerService.class);
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.ctx = ctx;
    }

    public List<Task> retrieveTasks() {
        return this.delegate.retrieveTasks();
    }

    public Task retrieveTask(long taskID) {
        return this.delegate.retrieveTask(taskID);
    }

    public Task updateTask(Task task, int manageSchedule) {
        return this.delegate.updateTask(task, manageSchedule);
    }

    public Task validateAndUpdateTask(Task task, int manageSchedule) throws ServerValidationException {
        return this.delegate.validateAndUpdateTask(task, manageSchedule);
    }

    public void deleteTask(long taskID) {
        this.delegate.deleteTask(taskID);
    }

    public void startTask(long taskID) {
        this.delegate.startTask(taskID);
    }

    public void stopTask(long taskID) {
        this.delegate.stopTask(taskID);
    }

    public TaskRuntimeStatus getRuntimeStatus(long taskID, Object clientData) {
        return this.delegate.getRuntimeStatus(taskID, clientData);
    }

    public List<TaskRunResult> getHistory(long taskID) {
        return this.delegate.getHistory(taskID);
    }

    public TaskRunResult getLastRunResult(long taskID) {
        return this.delegate.getLastRunResult(taskID);
    }

    public TaskRuntimeStatus getVolatileRuntimeStatus(String userId, Object value) {
        return this.delegate.getVolatileRuntimeStatus(userId, value);
    }

    public String startVolatileTask(Task task) {
        return this.delegate.startVolatileTask(task);
    }

    public void stopVolatileTask(String userId) {
        this.delegate.stopVolatileTask(userId);
    }
}

