/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.ejb;

import com.bwanms.model.Schedule;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.SchedulerService;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.services.ejb.MBeanProxyFactory;
import com.bwanms.services.ejb.SchedulerManagementServiceMBean;
import com.bwanms.services.impl.SchedulerServiceImpl;
import java.util.Date;
import java.util.List;
import org.jboss.system.ServiceMBeanSupport;

public class SchedulerManagementService
extends ServiceMBeanSupport
implements SchedulerManagementServiceMBean {
    private SchedulerServiceImpl schedulerService;

    public String getName() {
        return "SchedulerManagementService";
    }

    public void startService() throws Exception {
        this.schedulerService = new SchedulerServiceImpl();
        this.rebind();
        List<Schedule> schedules = ServiceRegistry.getEntityManagerService().retrieveAll(Schedule.class);
        for (Schedule schedule : schedules) {
            schedule.setNextRun(this.schedulerService.startOrUpdateSchedule(schedule));
            ServiceRegistry.getEntityManagerService().save(schedule);
        }
    }

    public void stopService() throws Exception {
        this.unbind();
    }

    public Date startOrUpdateSchedule(Schedule schedule) {
        return this.schedulerService.startOrUpdateSchedule(schedule);
    }

    public void stopSchedule(Schedule schedule) {
        this.schedulerService.stopSchedule(schedule);
    }

    public Date getNextFireTime(long scheduleId) {
        return this.schedulerService.getNextFireTime(scheduleId);
    }

    private void rebind() {
        PlatformFactory.getApplicationLayerPlatform().getLookup().bind("bwanms/SchedulerService", MBeanProxyFactory.createProxy(SchedulerService.class, this.getServiceName()));
    }

    private void unbind() {
        PlatformFactory.getApplicationLayerPlatform().getLookup().unbind("bwanms/SchedulerService");
    }
}

