/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.ejb;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanProxyFactory {
    private static final Logger log = Logger.getLogger(MBeanProxyFactory.class);

    public static <T> T createProxy(Class<T> serviceInterface, String mbeanServiceName) {
        try {
            return MBeanProxyFactory.createProxy(serviceInterface, new ObjectName(mbeanServiceName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T createProxy(Class<T> serviceInterface, ObjectName mbeanServiceName) {
        log.debug((Object)("Creating proxy for: " + serviceInterface.getName() + " " + mbeanServiceName.toString()));
        return (T)Proxy.newProxyInstance(MBeanProxyFactory.class.getClassLoader(), new Class[]{serviceInterface}, (InvocationHandler)new MBeanInvocationHandler(mbeanServiceName));
    }

    private static class MBeanInvocationHandler
    implements InvocationHandler {
        private ObjectName mbeanServiceName;

        public MBeanInvocationHandler(ObjectName mbeanServiceName) {
            this.mbeanServiceName = mbeanServiceName;
        }

        private MBeanServer findMBeanServer() throws Exception {
            InitialContext context = new InitialContext();
            MBeanServer server = MBeanServerFactory.findMBeanServer(null).get(0);
            return server;
        }

        private String[] getSignatureFromMethod(Method method) {
            Class<?>[] parameters = method.getParameterTypes();
            String[] signature = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                signature[i] = parameters[i].getName();
            }
            return signature;
        }

        public Object invoke(Object target, Method method, Object[] params) {
            try {
                return this.findMBeanServer().invoke(this.mbeanServiceName, method.getName(), params, this.getSignatureFromMethod(method));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

