/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.ejb;

import com.bwanms.services.SessionService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class EJBServiceProxy {
    public static Object create(Object ejbRef, Class serviceIf) {
        return Proxy.newProxyInstance(serviceIf.getClassLoader(), new Class[]{serviceIf}, (InvocationHandler)new EJBServiceProxyInvocationHandler(ejbRef, serviceIf));
    }

    static class EJBServiceProxyInvocationHandler
    implements InvocationHandler {
        private Object ejbRef;
        private boolean session;

        public EJBServiceProxyInvocationHandler(Object ejbRef, Class serviceInterface) {
            this.ejbRef = ejbRef;
            this.session = SessionService.class.isAssignableFrom(serviceInterface);
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method remoteMethod = null;
            try {
                remoteMethod = this.ejbRef.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException nsme) {
                throw new RuntimeException("Can't find remote method for service method: " + method, nsme);
            }
            Object ret = null;
            try {
                ret = remoteMethod.invoke(this.ejbRef, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
            if (this.session && "close".equals(method.getName())) {
                try {
                    this.ejbRef.getClass().getMethod("remove", new Class[0]).invoke(this.ejbRef, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to remove session EJB: " + this.ejbRef.getClass().getName(), e);
                }
            }
            return ret;
        }
    }
}

