/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.ejb;

import com.bwanms.model.NetworkScanTask;
import com.bwanms.model.ScheduleRecurrence;
import com.bwanms.model.Task;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.model.TaskSchedule;
import com.bwanms.model.task.DatabaseAgingGenericTask;
import com.bwanms.model.task.Destination;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.ActiveTaskManager;
import com.bwanms.services.EntityManagerService;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.services.ejb.ActiveTaskManagerServiceMBean;
import com.bwanms.services.ejb.MBeanProxyFactory;
import com.bwanms.services.impl.ActiveTaskManagerImpl;
import java.util.Date;
import java.util.List;
import javax.naming.NamingException;
import org.jboss.system.ServiceMBeanSupport;

public class ActiveTaskManagerService
extends ServiceMBeanSupport
implements ActiveTaskManagerServiceMBean {
    private ActiveTaskManagerImpl activeTaskManagerInstance = null;

    public String getName() {
        return "ActiveTaskManagerService";
    }

    public void startService() throws Exception {
        List<DatabaseAgingGenericTask> dbaTasks;
        this.activeTaskManagerInstance = new ActiveTaskManagerImpl();
        this.rebind();
        EntityManagerService ems = ServiceRegistry.getEntityManagerService();
        List<NetworkScanTask> tasks = ems.retrieveAll(NetworkScanTask.class);
        if (tasks == null || tasks.isEmpty()) {
            NetworkScanTask task = new NetworkScanTask();
            task.setName("Network Scan");
            task.setState(0);
            task.setRetries(2);
            task.setTimeout(15000L);
            task.setCreatedBy("SYSTEM");
            task.setModifiedBy("SYSTEM");
            ems.save(task);
        }
        if ((dbaTasks = ems.retrieveAll(DatabaseAgingGenericTask.class)) == null || dbaTasks.isEmpty()) {
            this.createDBAgingTask(DatabaseAgingGenericTask.Table.EventHistory);
            this.createDBAgingTask(DatabaseAgingGenericTask.Table.AuditLog);
        }
    }

    private void createDBAgingTask(DatabaseAgingGenericTask.Table table) {
        ScheduleRecurrence scheduleRecurrence = new ScheduleRecurrence();
        scheduleRecurrence.setType(2);
        scheduleRecurrence.setEndType(0);
        scheduleRecurrence.setParam2(1);
        TaskSchedule taskSchedule = new TaskSchedule();
        taskSchedule.setScheduleStart(new Date(System.currentTimeMillis() + 3600000L));
        DatabaseAgingGenericTask dbaTask = new DatabaseAgingGenericTask();
        dbaTask.setName(table.toString() + " DAP");
        dbaTask.setState(0);
        dbaTask.setCreatedBy("SYSTEM");
        dbaTask.setModifiedBy("SYSTEM");
        Destination destination = new Destination();
        destination.setDestinationType(Destination.Type.CSV);
        String path = System.getProperty("OWARE_USER_ROOT");
        if (path == null || path.length() == 0) {
            path = System.getProperty("oware.user.root");
        }
        path = path + "/filesystem/archive";
        destination.setParam1(path);
        dbaTask.setDestination(destination);
        dbaTask.setTargetTable(table);
        dbaTask.setThreshold(50000L);
        try {
            EntityManagerService ems = ServiceRegistry.getEntityManagerService();
            taskSchedule.setRecurrence(ems.save(scheduleRecurrence));
            taskSchedule.setTask(ems.save(dbaTask));
            ems.save(taskSchedule);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    private DatabaseAgingGenericTask createDbaTask(String name, DatabaseAgingGenericTask.Table tableName) {
        DatabaseAgingGenericTask dbaTask = new DatabaseAgingGenericTask();
        dbaTask.setName(name);
        dbaTask.setState(0);
        dbaTask.setCreatedBy("SYSTEM");
        dbaTask.setModifiedBy("SYSTEM");
        Destination destination = new Destination();
        destination.setDestinationType(Destination.Type.CSV);
        String path = System.getProperty("OWARE_USER_ROOT");
        if (path == null || path.length() == 0) {
            path = System.getProperty("oware.user.root");
        }
        path = path + "/filesystem/archive";
        destination.setParam1(path);
        dbaTask.setDestination(destination);
        dbaTask.setTargetTable(tableName);
        dbaTask.setThreshold(20L);
        this.log.info((Object)"Created dbase entry");
        return dbaTask;
    }

    public void stopService() throws Exception {
        this.unbind();
    }

    private void rebind() throws NamingException {
        PlatformFactory.getApplicationLayerPlatform().getLookup().bind("bwanms/ActiveTaskManager", MBeanProxyFactory.createProxy(ActiveTaskManager.class, this.getServiceName()));
    }

    private void unbind() {
        PlatformFactory.getApplicationLayerPlatform().getLookup().unbind("bwanms/ActiveTaskManager");
    }

    public void startTask(long taskID) {
        this.activeTaskManagerInstance.startTask(taskID);
    }

    public void stopTask(long taskID) {
        this.activeTaskManagerInstance.stopTask(taskID);
    }

    public void taskStateChanged(Task task) {
        this.activeTaskManagerInstance.taskStateChanged(task);
    }

    public void deleteTask(long taskID) {
        this.activeTaskManagerInstance.deleteTask(taskID);
    }

    public TaskRuntimeStatus getTaskRuntimeStatus(long taskID, Object clientData) {
        return this.activeTaskManagerInstance.getTaskRuntimeStatus(taskID, clientData);
    }

    public TaskRuntimeStatus getVolatileRuntimeStatus(String userId, Object clientData) {
        return this.activeTaskManagerInstance.getVolatileRuntimeStatus(userId, clientData);
    }

    public String startVolatileTask(Task task) {
        return this.activeTaskManagerInstance.startVolatileTask(task);
    }

    public void stopVolatileTask(String userId) {
        this.activeTaskManagerInstance.stopVolatileTask(userId);
    }
}

