/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services;

import com.bwanms.backend.services.EventManagerService;
import com.bwanms.backend.services.IMonitor;
import com.bwanms.entitymanager.EntityQuerySession;
import com.bwanms.mediation.FileSystemService;
import com.bwanms.services.AuditLogsService;
import com.bwanms.services.ConfigurationService;
import com.bwanms.services.EntityManagerService;
import com.bwanms.services.InventoryManagementService;
import com.bwanms.services.LicenseManagerService;
import com.bwanms.services.PerformanceCollectionViewerService;
import com.bwanms.services.ServerUtilService;
import com.bwanms.services.ServiceManagementService;
import com.bwanms.services.SettingsService;
import com.bwanms.services.SubscriberManagementService;
import com.bwanms.services.TaskManagerService;
import com.bwanms.services.TemplateManagerService;
import com.bwanms.services.TopologyManagerService;
import com.bwanms.util.PlatformConfiguration;
import org.apache.log4j.Logger;

public abstract class ServiceRegistry {
    private static final Logger logger = Logger.getLogger(ServiceRegistry.class);
    private static ServiceRegistry instance = ServiceRegistry.createServiceRegistry();

    private static ServiceRegistry createServiceRegistry() {
        try {
            return (ServiceRegistry)PlatformConfiguration.instance().getServiceRegistryImpl().newInstance();
        }
        catch (Throwable e) {
            logger.error((Object)"createServiceRegistry()", e);
            return null;
        }
    }

    public static EventManagerService getEventManagerService() {
        return ServiceRegistry.instance().getEventManagerServiceInstance();
    }

    public static ServerUtilService getServerUtilService() {
        return ServiceRegistry.instance().getServerUtilServiceInstance();
    }

    public static AuditLogsService getAuditLogsService() {
        return ServiceRegistry.instance().getAuditLogsServiceInstance();
    }

    public static ConfigurationService getConfigurationService() {
        return ServiceRegistry.instance().getConfigurationServiceInstance();
    }

    public static InventoryManagementService getInventoryManagementService() {
        return ServiceRegistry.instance().getInventoryManagementServiceInstance();
    }

    public static ServiceManagementService getServiceManagementService() {
        return ServiceRegistry.instance().getServiceManagementServiceInstance();
    }

    public static TaskManagerService getTaskManagerService() {
        return ServiceRegistry.instance().getTaskManagerServiceInstance();
    }

    public static EntityQuerySession getEntityQuerySession() {
        return ServiceRegistry.instance().getEntityQuerySessionInstance();
    }

    public static EntityManagerService getEntityManagerService() {
        return ServiceRegistry.instance().getEntityManagerServiceInstance();
    }

    public static FileSystemService getFileSystemService() {
        return ServiceRegistry.instance().getFileSystemServiceInstance();
    }

    @Deprecated
    public static SubscriberManagementService getSubscriberManagementService() {
        return ServiceRegistry.instance().getSubscriberManagementServiceInstance();
    }

    public static SettingsService getSettingsService() {
        return ServiceRegistry.instance().getSettingsServiceInstance();
    }

    public static LicenseManagerService getLicenseManagerService() {
        return ServiceRegistry.instance().getLicenseManagerServiceInstance();
    }

    public static TopologyManagerService getTopologyManagerService() {
        return ServiceRegistry.instance().getTopologyManagerServiceInstance();
    }

    public static TemplateManagerService getTemplateManagerService() {
        return ServiceRegistry.instance().getTemplateManagerServiceInstance();
    }

    public static PerformanceCollectionViewerService getPerformanceCollectionViewerService() {
        return ServiceRegistry.instance().getPerformanceCollectionViewerServiceInstance();
    }

    public static IMonitor getMonitor() {
        return ServiceRegistry.instance().getMonitorInstance();
    }

    public static ServiceRegistry instance() {
        return instance;
    }

    protected abstract EventManagerService getEventManagerServiceInstance();

    protected abstract ServerUtilService getServerUtilServiceInstance();

    protected abstract AuditLogsService getAuditLogsServiceInstance();

    protected abstract ConfigurationService getConfigurationServiceInstance();

    protected abstract InventoryManagementService getInventoryManagementServiceInstance();

    protected abstract ServiceManagementService getServiceManagementServiceInstance();

    protected abstract TaskManagerService getTaskManagerServiceInstance();

    protected abstract EntityQuerySession getEntityQuerySessionInstance();

    protected abstract EntityManagerService getEntityManagerServiceInstance();

    protected abstract FileSystemService getFileSystemServiceInstance();

    protected abstract SubscriberManagementService getSubscriberManagementServiceInstance();

    protected abstract SettingsService getSettingsServiceInstance();

    protected abstract LicenseManagerService getLicenseManagerServiceInstance();

    protected abstract TopologyManagerService getTopologyManagerServiceInstance();

    protected abstract TemplateManagerService getTemplateManagerServiceInstance();

    protected abstract PerformanceCollectionViewerService getPerformanceCollectionViewerServiceInstance();

    protected abstract IMonitor getMonitorInstance();
}

