/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.schedule.jobs;

import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class RunnableJob
implements Job {
    private static final Logger log = Logger.getLogger(RunnableJob.class);
    public static final String MAP_KEY = "runnable";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        log.debug((Object)("STARTING EXECUTION FOR JOB " + context.getJobDetail().getFullName()));
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        Runnable runnable = (Runnable)dataMap.get((Object)MAP_KEY);
        if (runnable == null) {
            throw new JobExecutionException("No runnable defined in the Job Execution Context");
        }
        try {
            runnable.run();
        }
        catch (RuntimeException e) {
            throw new JobExecutionException("Runnable threw exception", (Exception)e, false);
        }
    }
}

