/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.schedule;

import com.bwanms.model.Schedule;
import com.bwanms.model.ScheduleRecurrence;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.quartz.CronTrigger;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class ScheduleHelper {
    public static Trigger makeTrigger(Schedule schedule) {
        SimpleTrigger trigger;
        if (schedule.getRecurrence() != null && schedule.getRecurrence().getType() == 5) {
            trigger = new CronTrigger("trigger-" + schedule.getId(), "DEFAULT");
            trigger.setMisfireInstruction(2);
        } else {
            trigger = new SimpleTrigger("trigger-" + schedule.getId(), "DEFAULT");
            trigger.setMisfireInstruction(5);
        }
        if (schedule.getScheduleStart() != null) {
            trigger.setStartTime(schedule.getScheduleStart());
        } else {
            trigger.setStartTime(new Date());
        }
        if (schedule.getRecurrence() != null && schedule.getRecurrence().getType() != 0) {
            String exp = null;
            ScheduleRecurrence recurrence = schedule.getRecurrence();
            switch (recurrence.getType()) {
                case 1: {
                    trigger.setRepeatInterval(schedule.getRecurrence().getParam2().longValue() * 60L * 1000L);
                    break;
                }
                case 2: {
                    trigger.setRepeatInterval(schedule.getRecurrence().getParam2().longValue() * 60L * 60L * 1000L);
                    break;
                }
                case 3: {
                    trigger.setRepeatInterval(schedule.getRecurrence().getParam2().longValue() * 24L * 60L * 60L * 1000L);
                    break;
                }
                case 4: {
                    if (recurrence.getParam1() == 1) {
                        trigger.setRepeatInterval(schedule.getRecurrence().getParam2().longValue() * 7L * 24L * 60L * 60L * 1000L);
                        break;
                    }
                    Calendar startTime = Calendar.getInstance();
                    startTime.setTime(schedule.getScheduleStart());
                    if (startTime.get(7) > recurrence.getParam3()) {
                        startTime.add(5, 7 - (startTime.get(7) - recurrence.getParam3()));
                    } else if (startTime.get(7) < recurrence.getParam3()) {
                        startTime.add(5, recurrence.getParam3() - startTime.get(7));
                    }
                    trigger.setStartTime(startTime.getTime());
                    trigger.setRepeatInterval(schedule.getRecurrence().getParam2().longValue() * 7L * 24L * 60L * 60L * 1000L);
                    break;
                }
                case 5: {
                    Calendar now = Calendar.getInstance();
                    now.setTime(trigger.getStartTime());
                    StringBuilder buf = new StringBuilder();
                    buf.append(now.get(13));
                    buf.append(" ");
                    buf.append(now.get(12));
                    buf.append(" ");
                    buf.append(now.get(11));
                    buf.append(" ");
                    if (recurrence.getParam1() == 1) {
                        buf.append(now.get(5));
                    } else {
                        buf.append(recurrence.getParam3());
                    }
                    buf.append(" ");
                    buf.append(now.get(2) + 1);
                    buf.append("/");
                    if (recurrence.getParam1() == 1) {
                        buf.append(recurrence.getParam2());
                    } else {
                        buf.append(recurrence.getParam4());
                    }
                    buf.append(" ?");
                    exp = buf.toString();
                    if (exp == null) break;
                    ScheduleHelper.setCronExpression((Trigger)trigger, exp);
                }
            }
            switch (recurrence.getEndType()) {
                case 0: {
                    if (recurrence.getType() == 5) break;
                    trigger.setRepeatCount(SimpleTrigger.REPEAT_INDEFINITELY);
                    break;
                }
                case 1: {
                    trigger.setRepeatCount(recurrence.getEndOcurrences() - 1);
                    break;
                }
                case 2: {
                    if (recurrence.getType() != 5) {
                        trigger.setRepeatCount(SimpleTrigger.REPEAT_INDEFINITELY);
                    }
                    trigger.setEndTime(recurrence.getEndDate());
                }
            }
        }
        return trigger;
    }

    private static void setCronExpression(Trigger trigger, String exp) {
        try {
            ((CronTrigger)trigger).setCronExpression(exp);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static void testTriggers(Scheduler scheduler) {
        try {
            String[] triggerGroups = scheduler.getTriggerGroupNames();
            for (int i = 0; i < triggerGroups.length; ++i) {
                System.out.println("Group: " + triggerGroups[i] + " contains the following triggers");
                String[] triggersInGroup = scheduler.getTriggerNames(triggerGroups[i]);
                for (int j = 0; j < triggersInGroup.length; ++j) {
                    System.out.println("-" + triggersInGroup[j]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

