/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ruledelegator.redcell;

import RedCell.Config.Equipment;
import RedCell.Config.EquipmentKey;
import RedCell.Config.NetworkResourceKey;
import RedCell.Config.TopologyInfo;
import com.bwanms.ruledelegator.redcell.RCGenericQueryRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.common.utility.OWAttributeValuePair;
import com.dorado.common.utility.OWOID;
import com.dorado.core.bom.IOWBOMInternalUseMarker;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.bom.OWBOMQueryByOWOIDs;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.redcell.inventory.base.commandhandler.RCQueryCommandParamSet;
import com.dorado.redcell.inventory.base.commandhandler.RCQueryResults;
import com.dorado.runtime.IOWBean;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWBean;
import com.dorado.runtime.OWBeanUserAttributes;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.dorado.runtime.OWVector;
import com.ngnms.common.AvTrace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import redcell.core.security.RCBOMInternalUseMarker;

public class RCQueryChildEquipmentImpl
extends RCGenericQueryRuleImpl {
    boolean _sortOnComponentIndex = Boolean.getBoolean("redcell.equipment.component.index.sort");
    boolean _sortOnTrailingInt = Boolean.getBoolean("redcell.equipment.trailing.int.sort");
    boolean _sortOnTrailingFloat = Boolean.getBoolean("redcell.equipment.trailing.float.sort");
    boolean _preserverOrder = this._sortOnComponentIndex || this._sortOnTrailingInt || this._sortOnTrailingFloat ? false : Boolean.getBoolean("redcell.equipment.preserve.insert.order");

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln((String)"AvCS", (int)1, (String)">RCQueryChildEquipment.run()");
        this.runRule((RCQueryCommandParamSet)event);
        AvTrace.traceln((String)"AvCS", (int)1, (String)"<RCQueryChildEquipment.run()");
    }

    public void runRule(RCQueryCommandParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        super.runRule(pParamSet);
    }

    public Vector getChildList(IOWBean pParentBean) {
        Comparator _comp;
        int i;
        ArrayList _equipment;
        RCBOMInternalUseMarker _marker;
        Vector<Object> _equipVect;
        block27: {
            Equipment _parentBean = (Equipment)pParentBean;
            NetworkResourceKey _parentKey = _parentBean.getKey();
            _equipVect = new Vector<Object>();
            if (_parentKey == null) {
                return _equipVect;
            }
            OWVector _comps = _parentKey.getComponents();
            if (_comps == null) {
                return _equipVect;
            }
            if (this._preserverOrder) {
                EquipmentKey _equipKey = null;
                Object _equip = null;
                try {
                    for (int i2 = 0; i2 < _comps.size(); ++i2) {
                        _equipKey = (EquipmentKey)_comps.get(i2);
                        _equipVect.add(_equipKey.getNetworkResource());
                    }
                }
                catch (Exception _e) {
                    _e.printStackTrace();
                }
                return _equipVect;
            }
            _marker = RCBOMInternalUseMarker.getInstance();
            _equipment = new ArrayList();
            try {
                OWBOMQueryByAttribs _query = new OWBOMQueryByAttribs("RedCell.Config.EquipmentKey", new OWBOMAttribValueOperator("ParentKey", "=", (Object)_parentKey), true);
                ArrayList _results = this.getBOM().getObjects((OWBOMQuery)_query).getReturnObjects();
                OWBeanUserAttributes _attribs = null;
                OWBean _bean = null;
                OWAttributeValuePair _avp = null;
                ArrayList<OWOID> _eqOids = new ArrayList<OWOID>(_results.size() > 150 ? 150 : _results.size());
                for (i = 0; i < _results.size(); ++i) {
                    _attribs = ((OWBean)_results.get(i)).getUserAttributes((IOWBOMInternalUseMarker)_marker);
                    _avp = _attribs.get((Object)"NetworkResource", (IOWBOMInternalUseMarker)_marker);
                    if (_avp == null || (_bean = (OWBean)_avp.getValue()) == null) continue;
                    _eqOids.add(_bean.getHandle());
                    if (_eqOids.size() <= 99 || _results.size() - i <= 20) continue;
                    try {
                        OWBOMQueryByOWOIDs _oidQuery = new OWBOMQueryByOWOIDs(_eqOids);
                        _oidQuery.setDepth(0);
                        _equipment.addAll(this.getBOM().getObjects((OWBOMQuery)_oidQuery).getReturnObjects());
                    }
                    catch (Exception _e2) {
                        // empty catch block
                    }
                    _eqOids.clear();
                }
                if (_eqOids.size() <= 0) break block27;
                try {
                    OWBOMQueryByOWOIDs _oidQuery = new OWBOMQueryByOWOIDs(_eqOids);
                    _oidQuery.setDepth(0);
                    _equipment.addAll(this.getBOM().getObjects((OWBOMQuery)_oidQuery).getReturnObjects());
                }
                catch (Exception _e2) {
                    // empty catch block
                }
                _eqOids.clear();
            }
            catch (Exception _e) {
                // empty catch block
            }
        }
        if (_equipment.size() == 0) {
            return _equipVect;
        }
        if (this._sortOnTrailingInt) {
            _comp = new ChildEquipTrailingIntComparator();
            Collections.sort(_equipment, _comp);
        } else if (this._sortOnTrailingFloat) {
            _comp = new ChildEquipTrailingFloatComparator();
            Collections.sort(_equipment, _comp);
        } else if (this._sortOnComponentIndex) {
            ArrayList<OWOID> _topInfoOids = new ArrayList<OWOID>(_equipment.size() > 150 ? 150 : _equipment.size());
            HashMap<OWOID, OWBean> _topInfos = new HashMap<OWOID, OWBean>(_equipment.size());
            ArrayList _results = null;
            OWBeanUserAttributes _attribs = null;
            OWBean _bean = null;
            OWAttributeValuePair _avp = null;
            for (i = 0; i < _equipment.size(); ++i) {
                _attribs = ((OWBean)_equipment.get(i)).getUserAttributes((IOWBOMInternalUseMarker)_marker);
                _avp = _attribs.get((Object)"TopologyInfo", (IOWBOMInternalUseMarker)_marker);
                if (_avp == null || (_bean = (OWBean)_avp.getValue()) == null) continue;
                _topInfoOids.add(_bean.getHandle());
                if (_topInfoOids.size() <= 99 || _equipment.size() - i <= 20) continue;
                try {
                    OWBOMQueryByOWOIDs _query = new OWBOMQueryByOWOIDs(_topInfoOids);
                    _results = this.getBOM().getObjects((OWBOMQuery)_query).getReturnObjects();
                    for (int j = 0; j < _results.size(); ++j) {
                        _bean = (OWBean)_results.get(j);
                        _topInfos.put(_bean.getHandle(), _bean);
                    }
                }
                catch (Exception _e) {
                    // empty catch block
                }
                _topInfoOids.clear();
            }
            if (_topInfoOids.size() > 0) {
                try {
                    OWBOMQueryByOWOIDs _query = new OWBOMQueryByOWOIDs(_topInfoOids);
                    _results = this.getBOM().getObjects((OWBOMQuery)_query).getReturnObjects();
                    for (int j = 0; j < _results.size(); ++j) {
                        _bean = (TopologyInfo)_results.get(j);
                        _topInfos.put(_bean.getHandle(), _bean);
                    }
                }
                catch (Exception _e) {
                    // empty catch block
                }
                _topInfoOids.clear();
            }
            ChildEquipComparator _comp2 = new ChildEquipComparator(_topInfos);
            Collections.sort(_equipment, _comp2);
        }
        _equipVect.addAll(_equipment);
        return _equipVect;
    }

    public void sortResults(RCQueryResults pResults) {
        if (this._preserverOrder || this._sortOnComponentIndex || this._sortOnTrailingInt || this._sortOnTrailingFloat) {
            return;
        }
        super.sortResults(pResults);
    }

    protected class ChildEquipComparator
    implements Comparator {
        HashMap topInfosByOid = null;

        public ChildEquipComparator(HashMap pTopologyInfosByOid) {
            this.topInfosByOid = pTopologyInfosByOid;
        }

        public int compare(Object eq1, Object eq2) {
            int i2;
            TopologyInfo info1 = ((Equipment)eq1).getTopologyInfo();
            TopologyInfo info2 = ((Equipment)eq2).getTopologyInfo();
            if (info1 != null) {
                info1 = (TopologyInfo)this.topInfosByOid.get(info1.getHandle());
            }
            if (info2 != null) {
                info2 = (TopologyInfo)this.topInfosByOid.get(info2.getHandle());
            }
            int i1 = info1 != null ? info1.getComponentIndex() : 0;
            int n = i2 = info2 != null ? info2.getComponentIndex() : 0;
            if (i1 < i2) {
                return -1;
            }
            return 1;
        }
    }

    protected class ChildEquipTrailingFloatComparator
    implements Comparator {
        public int compare(Object eq1, Object eq2) {
            float _f2;
            float _f1 = this.getTrailingFloat(((Equipment)eq1).getName());
            if (_f1 < (_f2 = this.getTrailingFloat(((Equipment)eq2).getName()))) {
                return -1;
            }
            return 1;
        }

        private float getTrailingFloat(String pStr) {
            int i;
            int _numPoints = 0;
            byte[] _chars = pStr.getBytes();
            for (i = pStr.length() - 1; i >= 0; --i) {
                if (_chars[i] == 46) {
                    if (_numPoints != 0) break;
                    ++_numPoints;
                    continue;
                }
                if (_chars[i] < 48 || _chars[i] > 57) break;
            }
            if (i == pStr.length() - 1) {
                return 0.0f;
            }
            return new Float(pStr.substring(++i)).floatValue();
        }
    }

    protected class ChildEquipTrailingIntComparator
    implements Comparator {
        public int compare(Object eq1, Object eq2) {
            int _i2;
            int _i1 = this.getTrailingInt(((Equipment)eq1).getName());
            if (_i1 < (_i2 = this.getTrailingInt(((Equipment)eq2).getName()))) {
                return -1;
            }
            return 1;
        }

        private int getTrailingInt(String pStr) {
            int i;
            byte[] _chars = pStr.getBytes();
            for (i = pStr.length() - 1; i >= 0 && _chars[i] >= 48 && _chars[i] <= 57; --i) {
            }
            if (i == pStr.length() - 1) {
                return 0;
            }
            return new Integer(pStr.substring(++i));
        }
    }
}

