/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ruledelegator.redcell;

import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.OWBOMAPIException;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.bom.OWBOMQueryByKey;
import com.dorado.core.bom.OWBOMQueryByOWOIDs;
import com.dorado.core.bom.OWBOMRequestException;
import com.dorado.core.ejb.ruleengine.IOWRuleEngineRuleInterface;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.core.message.OWMSGQuery;
import com.dorado.oware.core.security.OWObjectGroup;
import com.dorado.redcell.inventory.base.commandhandler.RCDeleteCommandParamSet;
import com.dorado.redcell.inventory.base.commandhandler.RCRuleStatus;
import com.dorado.redcell.rci.assocframework.AssociationUtilFactory;
import com.dorado.redcell.rci.assocframework.IAssociationHelper42;
import com.dorado.redcell.rci.assocframework.IEDeleteAssociations;
import com.dorado.redcell.rci.topology.EntityStateNPC;
import com.dorado.redcell.rci.topology.IETopologyPublishEntityState;
import com.dorado.redcell.rci.topology.ITopologyStatePublisher42;
import com.dorado.redcell.rci.topology.TopologyMgrFactory;
import com.dorado.runtime.IOWBean;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWBean;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.common.AvTrace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class RCGenericDeleteRuleImpl
extends BaseRuleImpl {
    private String _refIntegrityFailedMsg = null;
    private boolean isBatchMode = false;
    private static final Logger log4j = Logger.getLogger(RCGenericDeleteRuleImpl.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln((String)"AvCS", (int)1, (String)">RCGenericDeleteRule.run()");
        this.runRule((RCDeleteCommandParamSet)event);
        AvTrace.traceln((String)"AvCS", (int)1, (String)"<RCGenericDeleteRule.run()");
    }

    public void runRule(RCDeleteCommandParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        RCRuleStatus _status = new RCRuleStatus();
        IOWBOMClient _bom = this.getBOM();
        _status.setSuccess(false);
        try {
            ArrayList _oids = new ArrayList(110);
            ArrayList _rtnObjs = new ArrayList(pParamSet.getOids().size());
            Iterator _iter = pParamSet.getOids().getCollection().iterator();
            while (_iter.hasNext()) {
                _oids.add(_iter.next());
                if (_oids.size() <= 99) continue;
                OWBOMQueryByOWOIDs _query = new OWBOMQueryByOWOIDs(_oids, pParamSet.getBaseClassName(), false);
                _query.setDepth(0);
                _rtnObjs.addAll(_bom.getObjects((OWBOMQuery)_query).getReturnObjects());
                _oids.clear();
            }
            if (_oids.size() > 0) {
                OWBOMQueryByOWOIDs _query = new OWBOMQueryByOWOIDs(_oids, pParamSet.getBaseClassName(), false);
                _query.setDepth(0);
                _rtnObjs.addAll(_bom.getObjects((OWBOMQuery)_query).getReturnObjects());
                _oids.clear();
            }
            if (_rtnObjs.size() > 0) {
                if (this.isBatchMode()) {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)"deleting in BatchMode");
                    }
                    if (!this.checkRefIntegrity(_rtnObjs, pParamSet.getDeleteChildren())) {
                        _status.setMessage(this.getRefIntegrityFailedMsg());
                        pParamSet.setStatus(_status);
                        return;
                    }
                    this.deleteBeans(_rtnObjs, pParamSet.getDeleteChildren());
                } else {
                    int i;
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)"deleting one by one.");
                    }
                    IOWBean _bean = null;
                    for (i = 0; i < _rtnObjs.size(); ++i) {
                        _bean = (IOWBean)_rtnObjs.get(i);
                        if (this.checkRefIntegrity(_bean, pParamSet.getDeleteChildren())) continue;
                        _status.setMessage(this.getRefIntegrityFailedMsg());
                        pParamSet.setStatus(_status);
                        return;
                    }
                    for (i = 0; i < _rtnObjs.size(); ++i) {
                        _bean = (IOWBean)_rtnObjs.get(i);
                        this.deleteBean(_bean, pParamSet.getDeleteChildren());
                    }
                }
                _bom.commitAll();
            }
            _status.setSuccess(true);
        }
        catch (Exception _e) {
            log4j.error((Object)"Exception", (Throwable)_e);
            _status.setMessage(_e.getMessage());
        }
        pParamSet.setStatus(_status);
    }

    public boolean checkRefIntegrity(IOWBean pBean, boolean pCheckChildren) {
        return true;
    }

    public boolean checkRefIntegrity(ArrayList pBeans, boolean pCheckChildren) {
        return true;
    }

    public String getRefIntegrityFailedMsg() {
        if (this._refIntegrityFailedMsg == null) {
            this._refIntegrityFailedMsg = OWMSGQuery.fetchMessageByNumber((long)24L, (String)"RC_Errors");
        }
        return this._refIntegrityFailedMsg;
    }

    public void setRefIntegrityFailedMsg(String pEntityName, String pRefEntityName) {
        this._refIntegrityFailedMsg = OWMSGQuery.fetchMessageByNumberWithSubstitution((long)23L, (String)"RC_Errors", (String[])new String[]{pEntityName, pRefEntityName});
    }

    public void setRefIntegrityFailedMsg(String pEntityName, Exception pException) {
        this._refIntegrityFailedMsg = OWMSGQuery.fetchMessageByNumberWithSubstitution((long)25L, (String)"RC_Errors", (String[])new String[]{pEntityName, pException.getMessage()});
        log4j.error((Object)"Exception", (Throwable)pException);
    }

    public boolean isBatchMode() {
        return this.isBatchMode;
    }

    public void setBatchMode(boolean pIsSupported) {
        this.isBatchMode = pIsSupported;
    }

    public void deleteBean(IOWBean pBean, boolean pDeleteChildren) throws Exception {
        if (pBean == null) {
            return;
        }
        try {
            this.getBOM().deleteObject(pBean);
        }
        catch (OWBOMAPIException oWBOMAPIException) {
            // empty catch block
        }
    }

    public void deleteBeans(ArrayList pBeans, boolean pDeleteChildren) throws Exception {
        this.internalDeleteBeans(pBeans);
    }

    public void internalDeleteBeans(ArrayList pBeans) throws Exception {
        if (pBeans == null) {
            return;
        }
        ArrayList _delList = new ArrayList(130);
        for (int i = 0; i < pBeans.size(); ++i) {
            _delList.add(pBeans.get(i));
            if (_delList.size() <= 99 || pBeans.size() - i <= 25) continue;
            try {
                this.getBOM().deleteObjects(_delList);
            }
            catch (OWBOMAPIException _be) {
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)"Caught and OWBOMAPIException, trying delete one at a time.");
                }
                for (int j = 0; j < _delList.size(); ++j) {
                    try {
                        this.getBOM().deleteObject((IOWBean)((OWBean)_delList.get(j)));
                        continue;
                    }
                    catch (OWBOMAPIException _be2) {
                        // empty catch block
                    }
                }
            }
            _delList.clear();
        }
        if (_delList.size() > 0) {
            try {
                this.getBOM().deleteObjects(_delList);
            }
            catch (OWBOMAPIException _be) {
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)"Caught and OWBOMAPIException, trying delete one at a time.");
                }
                for (int j = 0; j < _delList.size(); ++j) {
                    try {
                        this.getBOM().deleteObject((IOWBean)((OWBean)_delList.get(j)));
                        continue;
                    }
                    catch (OWBOMAPIException _be2) {
                        // empty catch block
                    }
                }
            }
            _delList.clear();
        }
    }

    public void deleteObjectGroup(String pID) {
        try {
            OWBOMQueryByKey _qbk = new OWBOMQueryByKey("com.dorado.oware.core.security.OWObjectGroup", pID);
            OWObjectGroup _securityGroup = (OWObjectGroup)this.getBOM().getObject(_qbk).getRtnObject();
            this.getBOM().deleteObject((IOWBean)_securityGroup);
        }
        catch (OWBOMNotFoundException _bnfe) {
        }
        catch (Exception _e) {
            log4j.error((Object)"Exception", (Throwable)_e);
        }
    }

    public void deleteObjectGroups(ArrayList pIDs) {
        if (pIDs == null || pIDs.size() == 0) {
            return;
        }
        ArrayList _groups = new ArrayList(pIDs.size());
        OWBOMQueryByAttribs _query = null;
        String _id = null;
        for (int i = 0; i < pIDs.size(); ++i) {
            _id = (String)pIDs.get(i);
            try {
                if (_query == null) {
                    _query = new OWBOMQueryByAttribs("com.dorado.oware.core.security.OWObjectGroup", true);
                    _query.addAttribValueOperator(new OWBOMAttribValueOperator("GroupID", "=", (Object)_id));
                } else {
                    _query.addAttribValueOperator(new OWBOMAttribValueOperator("OR", "GroupID", "=", (Object)_id));
                }
            }
            catch (OWBOMRequestException _re) {
                log4j.error((Object)"Exception", (Throwable)_re);
                return;
            }
            if ((i + 1) % 100 != 0 && i + 1 < pIDs.size()) continue;
            try {
                _groups.addAll(this.getBOM().getObjects((OWBOMQuery)_query).getReturnObjects());
            }
            catch (OWBOMNotFoundException _bnfe) {
            }
            catch (Exception _e) {
                log4j.error((Object)"Exception", (Throwable)_e);
            }
            _query = null;
        }
        try {
            this.internalDeleteBeans(_groups);
        }
        catch (Exception _e) {
            log4j.error((Object)"Exception", (Throwable)_e);
        }
    }

    public Set getEntityIds(ArrayList pBeans) {
        HashSet<String> _entityIds = new HashSet<String>();
        if (pBeans != null) {
            IOWBean _bean = null;
            for (int i = 0; i < pBeans.size(); ++i) {
                _bean = (IOWBean)pBeans.get(i);
                _entityIds.add(_bean.getHandle().getOID());
            }
        }
        return _entityIds;
    }

    public void deleteAssociations(Collection pBeans, boolean pDeleteChildren) throws Exception {
        IAssociationHelper42 _assocHelper = AssociationUtilFactory.createAssociationHelper((IOWRuleEngineRuleInterface)this.getEngine());
        HashSet<String> _entityIds = new HashSet<String>();
        for (IOWBean _bean : pBeans) {
            _entityIds.add(_bean.getHandle().getOID());
        }
        IEDeleteAssociations _ieDeleteAssociations = new IEDeleteAssociations();
        _ieDeleteAssociations.setEntityIds(_entityIds);
        _ieDeleteAssociations.setDescendents(pDeleteChildren);
        _ieDeleteAssociations.setCommitChanges(true);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)"Removing 'old' associations.");
        }
        _assocHelper.deleteAssociations(_ieDeleteAssociations);
    }

    public void publishDeletedEntityStateForTopology(String pOIDString) throws Exception {
        if (pOIDString != null && !pOIDString.trim().equals("")) {
            HashSet<String> _set = new HashSet<String>();
            _set.add(pOIDString);
            this.publishDeletedEntityStateForTopology(_set);
        } else if (log4j.isDebugEnabled()) {
            log4j.debug((Object)"OIDString was null.");
        }
    }

    public void publishDeletedEntityStateForTopology(Set pEntityIds) throws Exception {
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)"Entering publishDeletedEntityStateForTopology method...");
        }
        ArrayList<EntityStateNPC> _entityStateNPCs = new ArrayList<EntityStateNPC>();
        Iterator _iter = pEntityIds.iterator();
        while (_iter.hasNext()) {
            try {
                String _oid = (String)_iter.next();
                if (_oid == null || _oid.trim().equals("")) continue;
                EntityStateNPC _entityStateNPC = new EntityStateNPC();
                _entityStateNPC.setEntityId(_oid);
                _entityStateNPC.setState(2);
                _entityStateNPCs.add(_entityStateNPC);
            }
            catch (ClassCastException _e) {
                log4j.error((Object)"This item in the list was not an OID string.", (Throwable)_e);
            }
            catch (OWMutatorException _e) {
                log4j.error((Object)_e);
            }
        }
        if (!_entityStateNPCs.isEmpty()) {
            ITopologyStatePublisher42 _stateMgr = TopologyMgrFactory.getTopologyStatePublisher();
            IETopologyPublishEntityState _publishEvent = new IETopologyPublishEntityState();
            _publishEvent.setEntityStates(_entityStateNPCs);
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"Calling State Manager to publishEntityState.");
            }
            _stateMgr.publishEntityState(_publishEvent);
        }
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)"Exiting publishDeletedEntityStateForTopology method...");
        }
    }
}

