/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.protocols.tftp.impl;

import com.bwanms.protocols.tftp.impl.TftpPacket;
import java.net.DatagramPacket;
import java.net.InetAddress;

class TftpPacketFactory {
    private InetAddress host;
    private int port;

    public TftpPacketFactory(InetAddress host, int port) {
        this.host = host;
        this.port = port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public DatagramPacket buildRequestPacket(short opcode, String filename, String mode) {
        TftpPacket reqData = new TftpPacket(2 + filename.length() + 1 + 5 + 1);
        reqData.putInt(opcode, 0);
        reqData.putString(filename, 2);
        reqData.putString(mode, 2 + filename.length() + 1);
        return reqData.mkPacket(this.host, this.port);
    }

    public DatagramPacket buildReceivePacket() {
        TftpPacket recvData = new TftpPacket(516);
        return recvData.mkPacket();
    }

    public DatagramPacket buildAckPacket(int blockNum) {
        TftpPacket ackData = new TftpPacket(4);
        ackData.putInt(4, 0);
        ackData.putInt(blockNum, 2);
        DatagramPacket ret = ackData.mkPacket();
        ret.setPort(this.port);
        ret.setAddress(this.host);
        ret.setLength(4);
        return ret;
    }

    public DatagramPacket buildDataPacket(int blockNum, byte[] data) {
        return this.buildDataPacket(blockNum, data, 0, data.length);
    }

    public DatagramPacket buildDataPacket(int blockNum, byte[] data, int offset, int len) {
        TftpPacket dataObj = new TftpPacket(len + 4);
        dataObj.putInt(3, 0);
        dataObj.putInt(blockNum, 2);
        dataObj.putData(data, offset, 4, len);
        DatagramPacket dataPacket = dataObj.mkPacket();
        dataPacket.setPort(this.port);
        dataPacket.setAddress(this.host);
        dataPacket.setLength(len + 4);
        return dataPacket;
    }

    public static boolean isLastPacket(DatagramPacket packet) {
        return packet.getLength() < 516;
    }

    public DatagramPacket buildErrorPacket(int errorCode, String errorMsg) {
        TftpPacket errorObj = new TftpPacket(4 + errorMsg.length() + 1);
        errorObj.putInt(5, 0);
        errorObj.putInt(errorCode, 2);
        errorObj.putString(errorMsg, 4);
        DatagramPacket errPacket = errorObj.mkPacket();
        errPacket.setPort(this.port);
        errPacket.setAddress(this.host);
        errPacket.setLength(4 + errorMsg.length() + 1);
        return errPacket;
    }
}

