/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.protocols.tftp.impl;

import java.net.DatagramPacket;
import java.net.InetAddress;

public class TftpPacket {
    public static final int MAX_PACKET_SIZE = 512;
    public static final int MAX_DATA_SIZE = 512;
    public static final int TFTP_DEFAULT_PORT = 69;
    public static final String TFTP_netascii = "netascii";
    public static final String TFTP_octet = "octet";
    public static final short TFTP_RRQ = 1;
    public static final short TFTP_WRQ = 2;
    public static final short TFTP_DATA = 3;
    public static final short TFTP_ACK = 4;
    public static final short TFTP_ERROR = 5;
    public static final short TFTP_ERROR_NA = 0;
    public static final short TFTP_ERROR_FILE_NOT_FOUND = 1;
    public static final short TFTP_ERROR_ACCESS_VIOLATION = 2;
    public static final short TFTP_ERROR_DISK_OR_SERVER_FULL = 3;
    public static final short TFTP_ERROR_ILLEGAL_OPERATION = 4;
    public static final short TFTP_ERROR_UNKNOWN_TRANSFER_ID = 5;
    public static final short TFTP_ERROR_FILE_EXISTS = 6;
    public static final short TFTP_ERROR_NO_SUCH_USER = 7;
    public static final String[] TFTP_ERRORS = new String[]{"Not defined, see error message (if any).", "File not found.", "Access violation.", "Disk full or allocation exceeded.", "Illegal TFTP operation.", "Unknown transfer ID.", "File already exists.", "No such user.", "File not found."};
    public static final String[] TFTP_OPCODES = new String[]{"", "RRQ", "WRQ", "DATA", "ACK", "ERROR"};
    private byte[] data;

    public TftpPacket(byte[] newData) {
        this.data = new byte[newData.length];
        this.setData(newData);
    }

    public TftpPacket(int len) {
        this.data = new byte[len];
    }

    public TftpPacket(DatagramPacket pack) {
        this.data = new byte[pack.getLength()];
        System.arraycopy(pack.getData(), pack.getOffset(), this.data, 0, this.data.length);
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] newData) {
        System.arraycopy(newData, 0, this.data, 0, this.data.length);
    }

    public void putData(byte[] pData, int srcOffset, int destOffset, int len) {
        System.arraycopy(pData, srcOffset, this.data, destOffset, len);
    }

    public void putData(byte[] pData, int srcOffset, int destOffset) {
        this.putData(pData, srcOffset, destOffset, pData.length);
    }

    public void putData(byte[] pData, int destOffset) {
        this.putData(pData, 0, destOffset, pData.length);
    }

    public int length() {
        return this.data.length;
    }

    public DatagramPacket mkPacket() {
        return new DatagramPacket(this.data, this.data.length);
    }

    public DatagramPacket mkPacket(int len) {
        return new DatagramPacket(this.data, len);
    }

    public DatagramPacket mkPacket(InetAddress dest, int port) {
        return new DatagramPacket(this.data, this.data.length, dest, port);
    }

    public DatagramPacket mkPacket(InetAddress dest, int port, int len) {
        return new DatagramPacket(this.data, len, dest, port);
    }

    public byte getByte(int offset) {
        return this.data[offset];
    }

    public void setByte(int offset, byte value) {
        this.data[offset] = value;
    }

    public int getInt(int offset) {
        byte lo = this.data[offset + 1];
        int signBit = lo & 0x80;
        lo = (byte)(lo & 0x7F);
        byte hiByte = this.data[offset];
        byte loByte = lo;
        return (hiByte << 8) + signBit + loByte;
    }

    public void putInt(int val, int offset) {
        int loByte = val % 256;
        int hiByte = val >>> 8;
        this.data[offset] = (byte)hiByte;
        this.data[offset + 1] = (byte)loByte;
    }

    public String getString(int offset) {
        StringBuffer strBuf = new StringBuffer();
        int curPos = offset;
        while (this.data[curPos] != 0) {
            strBuf.append((char)this.data[curPos]);
            ++curPos;
        }
        return new String(strBuf);
    }

    public void putString(String str, int offset) {
        byte[] bytes = str.getBytes();
        System.arraycopy(bytes, 0, this.data, offset, bytes.length);
        this.data[offset + str.length()] = 0;
    }

    public int getOpcode() {
        return this.getInt(0);
    }

    public int getPacketNumber() {
        return this.getInt(2);
    }

    public void setOpcode(int opcode) {
        this.putInt(opcode, 0);
    }

    public void setPacketNumber(int packetNo) {
        this.putInt(packetNo, 1);
    }

    public boolean isDataPacket() {
        return this.getOpcode() == 3;
    }

    public boolean isAckPacket() {
        return this.getOpcode() == 4;
    }
}

