/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.protocols.tftp.impl;

import com.bwanms.protocols.tftp.TftpClient;
import com.bwanms.protocols.tftp.TftpException;
import com.bwanms.protocols.tftp.TftpProgressMonitor;
import com.bwanms.protocols.tftp.TftpServerException;
import com.bwanms.protocols.tftp.TftpTimeoutException;
import com.bwanms.protocols.tftp.impl.TftpPacket;
import com.bwanms.protocols.tftp.impl.TftpPacketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import org.apache.log4j.Logger;

public class TftpClientImpl
implements TftpClient {
    private static final Logger log = Logger.getLogger(TftpClientImpl.class);
    private String tftpServerAddress;
    private int remotePort = 69;
    private int retries = 3;
    private int timeOut = 3000;

    public TftpClientImpl(String tftpServerAddress) {
        this.tftpServerAddress = tftpServerAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public String getTftpServerAddress() {
        return this.tftpServerAddress;
    }

    public void put(String remoteFileName, InputStream in, TftpProgressMonitor progressMonitor) throws TftpException {
        InetAddress server = null;
        DatagramSocket sock = null;
        try {
            server = InetAddress.getByName(this.tftpServerAddress);
            sock = new DatagramSocket();
            TftpTransferStateMachine stateMachine = new TftpTransferStateMachine(new TftpPacketFactory(server, this.remotePort), sock, remoteFileName, in, progressMonitor);
            stateMachine.run();
        }
        catch (IOException e) {
            throw new TftpException(e);
        }
        finally {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (Exception e) {
                    log.debug((Object)"", (Throwable)e);
                }
            }
        }
    }

    public void get(String remoteFileName, OutputStream out, TftpProgressMonitor progressMonitor) throws TftpException {
        InetAddress server = null;
        DatagramSocket sock = null;
        try {
            server = InetAddress.getByName(this.tftpServerAddress);
            sock = new DatagramSocket();
            TftpTransferStateMachine stateMachine = new TftpTransferStateMachine(new TftpPacketFactory(server, this.remotePort), sock, remoteFileName, out, progressMonitor);
            stateMachine.run();
        }
        catch (IOException e) {
            throw new TftpException(e);
        }
        finally {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (Exception e) {
                    log.debug((Object)"", (Throwable)e);
                }
            }
        }
    }

    private class TftpTransferStateMachine {
        private byte[] buff = new byte[512];
        private int packetNo = 0;
        private int retryCount = 0;
        private DatagramSocket socket = null;
        private DatagramPacket currentPacket;
        private InputStream in = null;
        private OutputStream out = null;
        private long sendTimeStamp;
        private String remoteFileName;
        private TftpPacketFactory packetFactory;
        private TftpProgressMonitor progressMonitor;
        private long bytesTransferred = 0L;

        public TftpTransferStateMachine(TftpPacketFactory packetFactory, DatagramSocket socket, String remoteFileName, InputStream in, TftpProgressMonitor progressMonitor) {
            this.socket = socket;
            this.in = in;
            this.packetFactory = packetFactory;
            this.remoteFileName = remoteFileName;
            this.progressMonitor = progressMonitor;
        }

        public TftpTransferStateMachine(TftpPacketFactory packetFactory, DatagramSocket socket, String remoteFileName, OutputStream out, TftpProgressMonitor progressMonitor) {
            this.socket = socket;
            this.out = out;
            this.packetFactory = packetFactory;
            this.remoteFileName = remoteFileName;
            this.progressMonitor = progressMonitor;
        }

        public void run() throws IOException, TftpException {
            if (this.in != null) {
                this.put();
            } else {
                this.get();
            }
        }

        public void put() throws IOException, TftpException {
            boolean done = false;
            this.packetNo = 0;
            this.currentPacket = this.packetFactory.buildRequestPacket((short)2, this.remoteFileName, "octet");
            int lastPacketValidity = 0;
            while (!done) {
                DatagramPacket packet;
                if (this.retryCount > TftpClientImpl.this.retries) {
                    throw new TftpTimeoutException("Too many retries on packet " + this.packetNo + "(" + this.retryCount + ")");
                }
                if (lastPacketValidity == 0) {
                    this.send(this.currentPacket);
                }
                if ((packet = this.listen()) != null) {
                    TftpPacket tftpPacket = new TftpPacket(packet);
                    if (this.isErrorPacket(tftpPacket)) {
                        throw this.createException(tftpPacket);
                    }
                    lastPacketValidity = this.isValidAck(tftpPacket);
                    switch (lastPacketValidity) {
                        case 0: {
                            this.retryCount = 0;
                            if (this.packetNo == 0) {
                                this.packetFactory.setPort(packet.getPort());
                                this.socket.connect(packet.getSocketAddress());
                                this.currentPacket = this.readAndBuildNextDataPacket();
                                break;
                            }
                            this.progressMonitor.updateProgress(this.bytesTransferred);
                            if (TftpPacketFactory.isLastPacket(this.currentPacket)) {
                                done = true;
                                break;
                            }
                            this.currentPacket = this.readAndBuildNextDataPacket();
                            break;
                        }
                    }
                    continue;
                }
                ++this.retryCount;
                lastPacketValidity = 0;
            }
        }

        public void get() throws IOException, TftpException {
            boolean done = false;
            this.packetNo = 1;
            log.debug((Object)("[" + TftpClientImpl.this.tftpServerAddress + "] RRQ " + this.remoteFileName));
            this.currentPacket = this.packetFactory.buildRequestPacket((short)1, this.remoteFileName, "octet");
            int lastPacketValidity = 0;
            while (!done) {
                DatagramPacket packet;
                if (this.retryCount > TftpClientImpl.this.retries) {
                    throw new TftpTimeoutException("Too many retries on packet " + this.packetNo + "(" + this.retryCount + ")");
                }
                if (lastPacketValidity == 0) {
                    this.send(this.currentPacket);
                }
                if ((packet = this.listen()) != null) {
                    TftpPacket tftpPacket = new TftpPacket(packet);
                    if (this.isErrorPacket(tftpPacket)) {
                        throw this.createException(tftpPacket);
                    }
                    lastPacketValidity = this.isValidDataPacket(tftpPacket);
                    switch (lastPacketValidity) {
                        case 0: {
                            log.debug((Object)("[" + TftpClientImpl.this.tftpServerAddress + "] DATA Packet " + this.packetNo));
                            if (this.packetNo == 1) {
                                this.packetFactory.setPort(packet.getPort());
                                this.socket.connect(packet.getSocketAddress());
                            }
                            this.retryCount = 0;
                            done = TftpPacketFactory.isLastPacket(packet);
                            this.currentPacket = this.writeAndBuildAckPacket(tftpPacket);
                            this.progressMonitor.updateProgress(this.bytesTransferred);
                            break;
                        }
                        case 1: {
                            log.debug((Object)("[" + TftpClientImpl.this.tftpServerAddress + "] Invalid packet opcode"));
                            ++this.retryCount;
                            break;
                        }
                        case 2: {
                            log.debug((Object)("[" + TftpClientImpl.this.tftpServerAddress + "] Old DATA Packet"));
                        }
                    }
                    continue;
                }
                log.debug((Object)("[" + TftpClientImpl.this.tftpServerAddress + "] receive timeout"));
                ++this.retryCount;
                lastPacketValidity = 0;
            }
            this.send(this.currentPacket);
        }

        private void send(DatagramPacket packet) throws IOException {
            this.socket.send(packet);
            this.sendTimeStamp = System.currentTimeMillis();
        }

        private DatagramPacket listen() throws IOException {
            DatagramPacket recv = this.packetFactory.buildReceivePacket();
            int actualTimeout = (int)(this.sendTimeStamp + (long)TftpClientImpl.this.timeOut - System.currentTimeMillis());
            if (actualTimeout <= 0) {
                log.error((Object)("Negative timeout in listen: " + actualTimeout));
            }
            this.socket.setSoTimeout(actualTimeout > 0 ? actualTimeout : TftpClientImpl.this.timeOut);
            try {
                this.socket.receive(recv);
            }
            catch (SocketTimeoutException e) {
                this.sendTimeStamp = System.currentTimeMillis();
                return null;
            }
            return recv;
        }

        private int isValidAck(TftpPacket tftpPacket) {
            if (tftpPacket.getOpcode() != 4) {
                return 1;
            }
            if (tftpPacket.getPacketNumber() == this.packetNo) {
                return 0;
            }
            return 2;
        }

        private DatagramPacket readAndBuildNextDataPacket() throws IOException {
            ++this.packetNo;
            int readLen = Math.max(this.in.read(this.buff), 0);
            this.bytesTransferred += (long)readLen;
            return this.packetFactory.buildDataPacket(this.packetNo, this.buff, 0, readLen);
        }

        private DatagramPacket writeAndBuildAckPacket(TftpPacket packet) throws IOException {
            byte[] data = packet.getData();
            this.out.write(data, 4, data.length - 4);
            this.bytesTransferred += (long)(data.length - 4);
            return this.packetFactory.buildAckPacket(this.packetNo++);
        }

        private int isValidDataPacket(TftpPacket tftpPacket) {
            if (tftpPacket.getOpcode() != 3) {
                return 1;
            }
            if (tftpPacket.getPacketNumber() == this.packetNo) {
                return 0;
            }
            return 2;
        }

        private boolean isErrorPacket(TftpPacket tftpPacket) {
            return tftpPacket.getOpcode() == 5;
        }

        private TftpServerException createException(TftpPacket errorPacket) {
            StringBuilder builder = new StringBuilder();
            builder.append("Server reported: [").append(errorPacket.getPacketNumber()).append(" - ").append(TftpPacket.TFTP_ERRORS[errorPacket.getPacketNumber()]).append("] ").append(errorPacket.getString(4));
            return new TftpServerException(builder.toString(), errorPacket.getPacketNumber());
        }
    }
}

