/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.protocols.snmp.impl.snmp4j;

import com.bwanms.mediation.snmp.SNMPTrapFilter;
import com.bwanms.protocols.snmp.SNMPTrap;
import com.bwanms.protocols.snmp.SNMPTrapV1;
import com.bwanms.protocols.snmp.VarBindList;
import com.bwanms.protocols.snmp.impl.AbstractSNMPTrapListener;
import com.bwanms.protocols.snmp.impl.snmp4j.PDUTranslator;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.log4j.Logger;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SNMP4JTrapListener
extends AbstractSNMPTrapListener {
    private static final Logger log = Logger.getLogger(SNMP4JTrapListener.class);
    private Snmp snmp;

    public SNMP4JTrapListener(String ipAddress, int port) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(ipAddress);
        DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping(new UdpAddress(inetAddress, port));
        this.initialize((TransportMapping)transport);
    }

    public SNMP4JTrapListener() throws IOException {
        this(162);
    }

    public SNMP4JTrapListener(int port) throws IOException {
        DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping(new UdpAddress(port));
        this.initialize((TransportMapping)transport);
    }

    private void initialize(TransportMapping transport) throws IOException {
        this.snmp = new Snmp(transport);
        this.snmp.addCommandResponder((CommandResponder)new DefaultCommandResponder());
        transport.listen();
    }

    public void close() {
        try {
            this.snmp.close();
        }
        catch (Exception e) {
            log.debug((Object)"", (Throwable)e);
        }
    }

    private SNMPTrapV1 toSNMPTrapV1(PDUv1 pdu) {
        VarBindList vbList = PDUTranslator.createNgnmsVarBindList((PDU)pdu);
        return new SNMPTrapV1(pdu.getAgentAddress().getInetAddress().getHostAddress(), pdu.getEnterprise().toString(), pdu.getGenericTrap(), pdu.getSpecificTrap(), pdu.getTimestamp(), vbList, System.currentTimeMillis());
    }

    private SNMPTrap toSNMPTrap(String agentAddress, PDU pdu) {
        VarBindList vbList = PDUTranslator.createNgnmsVarBindList(pdu);
        return new SNMPTrap(agentAddress, vbList, System.currentTimeMillis());
    }

    private class DefaultCommandResponder
    implements CommandResponder {
        private DefaultCommandResponder() {
        }

        public void processPdu(CommandResponderEvent event) {
            PDU pdu = event.getPDU();
            if (pdu != null) {
                switch (pdu.getType()) {
                    case -92: {
                        PDUv1 pduv1 = (PDUv1)pdu;
                        if (!SNMPTrapFilter.acceptV1Trap(pduv1)) break;
                        SNMP4JTrapListener.this.dispatchTrap(SNMP4JTrapListener.this.toSNMPTrapV1(pduv1));
                        break;
                    }
                    case -89: {
                        String agentAddress = null;
                        agentAddress = event.getPeerAddress() instanceof IpAddress ? ((IpAddress)event.getPeerAddress()).getInetAddress().getHostAddress() : event.getPeerAddress().toString();
                        if (SNMPTrapFilter.acceptTrap(pdu, agentAddress)) {
                            SNMP4JTrapListener.this.dispatchTrap(SNMP4JTrapListener.this.toSNMPTrap(agentAddress, pdu));
                            break;
                        }
                        log.info((Object)"DISCARD TRAP: ");
                    }
                }
            }
        }
    }
}

