/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.protocols.snmp.impl.snmp4j;

import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.protocols.snmp.SNMPAgentError;
import com.bwanms.protocols.snmp.SNMPAgentErrorException;
import com.bwanms.protocols.snmp.SNMPException;
import com.bwanms.protocols.snmp.SNMPResponse;
import com.bwanms.protocols.snmp.SNMPSession;
import com.bwanms.protocols.snmp.SNMPTimeoutException;
import com.bwanms.protocols.snmp.SNMPv2AgentException;
import com.bwanms.protocols.snmp.VarBindList;
import com.bwanms.protocols.snmp.impl.snmp4j.PDUTranslator;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SNMP4JCommunityBasedSession
implements SNMPSession {
    private static final Logger logger = Logger.getLogger(SNMP4JCommunityBasedSession.class);
    private CommunityTarget readTarget;
    private CommunityTarget writeTarget;
    private static Snmp session = null;

    public SNMP4JCommunityBasedSession(SNMPManagementInterface agentInfo) throws SNMPException {
        int version;
        if (agentInfo.getVersion() == 0) {
            version = 0;
        } else if (agentInfo.getVersion() == 1) {
            version = 1;
        } else {
            throw new SNMPException("SNMP version is not community based");
        }
        Address address = GenericAddress.parse((String)("udp:" + agentInfo.getIp() + "/" + agentInfo.getPort()));
        this.readTarget = (CommunityTarget)this.createTarget(address, agentInfo.getReadCommunity(), agentInfo.getRetries(), agentInfo.getTimeout(), version);
        this.writeTarget = (CommunityTarget)this.createTarget(address, agentInfo.getWriteCommunity(), agentInfo.getRetries(), agentInfo.getTimeout(), version);
        try {
            if (session == null) {
                session = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
                session.listen();
            }
        }
        catch (IOException e) {
            throw new SNMPException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VarBindList get(VarBindList varBindings) throws SNMPException {
        ResponseEvent responseEvent = null;
        try {
            try {
                responseEvent = session.get(PDUTranslator.fromNgnmsPDU(varBindings, -96), (Target)this.readTarget);
            }
            catch (IOException e) {
                throw new SNMPException(e);
            }
            catch (IllegalStateException ise) {
                this.handleIllegalStateException(ise);
            }
            this.handleResponse(responseEvent, "GET");
            PDUTranslator.toNgnmsPDU(varBindings, responseEvent.getResponse());
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("%8s->(%s,%s)", "GET", varBindings, new SNMPResponse(responseEvent)));
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("%8s->(%s,%s)", "GET", varBindings, new SNMPResponse(responseEvent)));
        }
        return varBindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VarBindList getNext(VarBindList varBindings) throws SNMPException {
        ResponseEvent responseEvent = null;
        try {
            try {
                responseEvent = session.getNext(PDUTranslator.fromNgnmsPDU(varBindings, -95), (Target)this.readTarget);
            }
            catch (IOException e) {
                throw new SNMPException(e);
            }
            catch (IllegalStateException ise) {
                this.handleIllegalStateException(ise);
            }
            this.handleResponse(responseEvent, "GET_NEXT");
            PDUTranslator.toNgnmsPDU(varBindings, responseEvent.getResponse());
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("%8s->(%s,%s)", "GET_NEXT", varBindings.toRowString(), new SNMPResponse(responseEvent)));
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("%8s->(%s,%s)", "GET_NEXT", varBindings.toRowString(), new SNMPResponse(responseEvent)));
        }
        return varBindings;
    }

    @Override
    public VarBindList getBulk(int nonRepetears, int maxRepetitions, VarBindList varBindings) throws SNMPException {
        if (this.readTarget.getVersion() == 0) {
            throw new UnsupportedOperationException("SNMPv1 does not support GET_BULK");
        }
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public List<VarBindList> getTable(VarBindList varBindings, Object lowerBoundIndex, Object upperBoundIndex) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public void set(VarBindList varBindings) throws SNMPException {
        ResponseEvent responseEvent = null;
        try {
            responseEvent = session.set(PDUTranslator.fromNgnmsPDU(varBindings, -93), (Target)this.writeTarget);
        }
        catch (IllegalStateException ise) {
            this.handleIllegalStateException(ise);
        }
        this.handleResponse(responseEvent, "SET");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("finish %8s->(%s,%s)", "SET", varBindings, new SNMPResponse(responseEvent)));
        }
    }

    @Override
    public void close() {
    }

    private void handleResponse(ResponseEvent responseEvent, String operation) throws SNMPException {
        if (responseEvent == null || responseEvent.getResponse() == null) {
            throw new SNMPTimeoutException("[" + this.readTarget.getAddress() + "] Timeout on " + operation + " for " + this + ".");
        }
        if (responseEvent.getError() != null) {
            throw new SNMPException(responseEvent.getError());
        }
        PDU response = responseEvent.getResponse();
        if (response.getErrorStatus() != 0) {
            String oid = "";
            int errorIndex = response.getErrorIndex();
            if (errorIndex > 0 && errorIndex - 1 < response.size()) {
                oid = response.get(response.getErrorIndex() - 1).getOid().toString();
            }
            logger.debug((Object)String.format("error status: %d (%s); oid: %s", response.getErrorStatus(), response.getErrorStatusText(), oid));
            throw new SNMPAgentErrorException(new SNMPAgentError(response.getErrorStatus(), response.getErrorStatusText(), response.getErrorIndex(), response.getRequestID().toInt()));
        }
        for (VariableBinding varBind : response.getVariableBindings()) {
            Null var;
            if (!(varBind.getVariable() instanceof Null) || !(var = (Null)varBind.getVariable()).isException()) continue;
            switch (var.getSyntax()) {
                case 128: 
                case 129: {
                    throw new SNMPAgentErrorException(new SNMPv2AgentException(var.getSyntax()));
                }
                case 130: {
                    logger.debug((Object)("SMIv2 Exception: " + var));
                }
            }
        }
    }

    private Target createTarget(Address targetAddress, String community, int retries, long timeout, int version) {
        CommunityTarget target = new CommunityTarget();
        target.setAddress(targetAddress);
        target.setCommunity(new OctetString(community));
        target.setRetries(retries);
        target.setTimeout(timeout);
        target.setVersion(version);
        return target;
    }

    private void handleIllegalStateException(IllegalStateException ise) throws SNMPException {
        if (ise.getMessage().indexOf("Timer already cancelled") >= 0) {
            logger.error((Object)ise, (Throwable)ise);
            try {
                session.close();
            }
            catch (Throwable t) {
                logger.warn((Object)t);
                session = null;
            }
            try {
                session = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
                session.listen();
            }
            catch (IOException e) {
                throw new SNMPException(e);
            }
        }
    }
}

