/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.protocols.snmp.impl.snmp4j;

import com.bwanms.protocols.snmp.NullObject;
import com.bwanms.protocols.snmp.VarBind;
import com.bwanms.protocols.snmp.VarBindList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.snmp4j.PDU;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Opaque;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class PDUTranslator {
    private PDUTranslator() {
    }

    public static void toNgnmsPDU(VarBindList var, PDU response) {
        if (response != null) {
            Vector a = response.getVariableBindings();
            Iterator iter = a.iterator();
            Iterator iter2 = var.getVariableBindings().iterator();
            while (iter.hasNext() && iter2.hasNext()) {
                VariableBinding snmp4jVar = (VariableBinding)iter.next();
                VarBind ngnmsVar = (VarBind)iter2.next();
                ngnmsVar.setVariable(PDUTranslator.toNgnmsObject(ngnmsVar.getType(), snmp4jVar.getSyntax(), snmp4jVar.getVariable()));
                ngnmsVar.setOID(snmp4jVar.getOid().toString());
            }
        }
    }

    public static VarBindList createNgnmsVarBindList(PDU pdu) {
        VarBindList ret = new VarBindList();
        for (VariableBinding pduVar : pdu.getVariableBindings()) {
            VarBind varBind = new VarBind(pduVar.getOid().toString());
            varBind.setVariable(PDUTranslator.toNgnmsObject(-1, pduVar.getSyntax(), pduVar.getVariable()));
            varBind.setType(pduVar.getSyntax());
            ret.add(varBind);
        }
        return ret;
    }

    public static PDU fromNgnmsPDU(VarBindList vars, int type) {
        PDU pdu = new PDU();
        PDUTranslator.addVariableBindings(pdu, vars.getVariableBindings());
        pdu.setErrorIndex(0);
        pdu.setErrorStatus(0);
        pdu.setType(type);
        pdu.setRequestID(new Integer32(0));
        return pdu;
    }

    private static void addVariableBindings(PDU snmp4jPDU, List variableBindings) {
        for (VarBind var : variableBindings) {
            snmp4jPDU.add(PDUTranslator.convertToSNMP4jVariableBinding(var));
        }
    }

    private static VariableBinding convertToSNMP4jVariableBinding(VarBind var) {
        VariableBinding result = new VariableBinding(new OID(var.getOID()), PDUTranslator.fromNgnmsObject(var.getType(), var.getVariable()));
        return result;
    }

    private static Variable fromNgnmsObject(int type, Object variable) {
        Null result = null;
        if (variable == null) {
            result = new Null();
        } else {
            switch (type) {
                case 2: {
                    result = new Integer32(((Integer)variable).intValue());
                    break;
                }
                case 4: {
                    result = OctetString.fromHexString((String)variable.toString());
                    break;
                }
                case 5: {
                    result = new Null();
                    break;
                }
                case 6: {
                    result = new OID(variable.toString());
                    break;
                }
                case 48: {
                    throw new RuntimeException("Not yet implemented.");
                }
                case 64: {
                    result = new IpAddress((String)variable);
                    break;
                }
                case 65: {
                    result = new Counter32(((Long)variable).longValue());
                    break;
                }
                case 66: {
                    result = new Gauge32(((Long)variable).longValue());
                    break;
                }
                case 67: {
                    result = new TimeTicks(((Long)variable).longValue());
                    break;
                }
                case 68: {
                    result = new Opaque((byte[])variable);
                    break;
                }
                case 70: {
                    result = new Counter64(((Long)variable).longValue());
                    break;
                }
                case 112: {
                    result = OctetString.fromHexString((String)variable.toString());
                    break;
                }
                case -128: {
                    result = new OctetString(((String)variable).getBytes());
                    break;
                }
                default: {
                    throw new RuntimeException("Not yet implemented.");
                }
            }
        }
        return result;
    }

    private static Object toNgnmsObject(int targetType, int type, Variable variable) {
        Object result = null;
        if (variable == null) {
            result = null;
        } else if (variable instanceof Null) {
            result = new NullObject(type);
        } else {
            switch (type) {
                case 2: {
                    result = new Integer(((Integer32)variable).getValue());
                    break;
                }
                case 4: {
                    if (targetType == -128) {
                        result = new String(((OctetString)variable).getValue());
                        break;
                    }
                    result = ((OctetString)variable).toHexString();
                    break;
                }
                case 5: {
                    result = null;
                    break;
                }
                case 6: {
                    result = ((OID)variable).toString();
                    break;
                }
                case 48: {
                    throw new RuntimeException("Not yet implemented.");
                }
                case 64: {
                    result = ((IpAddress)variable).toString();
                    break;
                }
                case 65: {
                    result = new Long(((Counter32)variable).getValue());
                    break;
                }
                case 66: {
                    result = new Long(((Gauge32)variable).getValue());
                    break;
                }
                case 67: {
                    result = new Long(((TimeTicks)variable).getValue());
                    break;
                }
                case 68: {
                    result = ((Opaque)variable).getValue();
                    break;
                }
                case 70: {
                    result = new Long(((Counter64)variable).getValue());
                    break;
                }
                case 112: {
                    result = ((OctetString)variable).toHexString();
                    break;
                }
                case 128: 
                case 129: 
                case 130: {
                    result = new NullObject(type);
                    break;
                }
                default: {
                    throw new RuntimeException("Not yet implemented.");
                }
            }
        }
        return result;
    }
}

