/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.protocols.snmp;

import com.bwanms.protocols.snmp.VarBind;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarBindList
implements Iterable<VarBind>,
Serializable {
    protected ArrayList<VarBind> variableBindings = new ArrayList();

    public void add(VarBind vb) {
        this.variableBindings.add(vb);
    }

    public void addAll(VarBind[] vbs) {
        this.variableBindings.ensureCapacity(this.variableBindings.size() + vbs.length);
        for (int i = 0; i < vbs.length; ++i) {
            this.variableBindings.add(vbs[i]);
        }
    }

    public void clear() {
        this.variableBindings.clear();
    }

    public VarBind get(int index) {
        return this.variableBindings.get(index);
    }

    public VarBind set(int index, VarBind vb) {
        if (vb == null) {
            throw new NullPointerException("Variable binding must not be null");
        }
        return this.variableBindings.set(index, vb);
    }

    public void remove(int index) {
        this.variableBindings.remove(index);
    }

    public int size() {
        return this.variableBindings.size();
    }

    public List getVariableBindings() {
        return this.variableBindings;
    }

    public void trim() {
        if (this.variableBindings.size() > 0) {
            this.variableBindings.remove(this.variableBindings.size() - 1);
        }
    }

    public VarBind[] toArray() {
        VarBind[] vbs = new VarBind[this.variableBindings.size()];
        this.variableBindings.toArray(vbs);
        return vbs;
    }

    public static VarBindList create(VarBind variableBinding) {
        VarBindList result = new VarBindList();
        result.add(variableBinding);
        return result;
    }

    public static VarBindList create(String vars) {
        String[] variables = vars.split("[,]");
        VarBindList result = new VarBindList();
        for (int i = 0; i < variables.length; ++i) {
            result.add(new VarBind(variables[i].trim()));
        }
        return result;
    }

    public static VarBindList create(String name, String oid, byte type, Object value) {
        VarBind var = new VarBind(name, oid, type, value);
        VarBindList result = new VarBindList();
        result.add(var);
        return result;
    }

    public boolean isEmpty() {
        return this.variableBindings.isEmpty();
    }

    @Override
    public Iterator<VarBind> iterator() {
        return this.variableBindings.iterator();
    }

    public VarBind findVarBindByOID(String oid) {
        for (VarBind varBind : this.variableBindings) {
            String varBindOID = varBind.getOID();
            if (varBindOID == null || !varBindOID.equals(oid)) continue;
            return varBind;
        }
        return null;
    }

    public VarBind findVarBindwithInstanceByOID(String oid) {
        String oidPrefix = oid + ".";
        for (VarBind varBind : this.variableBindings) {
            if (!(varBind.getOID() + ".").startsWith(oidPrefix)) continue;
            return varBind;
        }
        return null;
    }

    public String toRowString() {
        return this.toString("; ");
    }

    public String toString() {
        return this.toString("\n\t");
    }

    public String toString(String separator) {
        StringBuffer buf = new StringBuffer();
        buf.append("VBS[");
        for (int i = 0; i < this.variableBindings.size(); ++i) {
            buf.append(separator);
            buf.append(this.variableBindings.get(i));
        }
        buf.append(separator);
        buf.append("]");
        return buf.toString();
    }
}

