/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.protocols.snmp;

import java.io.Serializable;

public class VarBind
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1032709950031514113L;
    private String name;
    private String oid;
    private Object variable;
    int type;

    public VarBind(String oid) {
        this(null, oid, 5, null);
    }

    public VarBind(String name, String oid, int type, Object value) {
        this.setName(name);
        this.setOID(oid);
        this.setType(type);
        this.setVariable(value);
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getOID() {
        return this.oid;
    }

    public void setOID(String oid) {
        if (oid == null) {
            throw new IllegalArgumentException("OID of a VariableBinding must not be null");
        }
        this.oid = oid;
    }

    public void setVariable(Object variable) {
        this.variable = variable;
    }

    public Object getVariable() {
        return this.variable;
    }

    public final int getType() {
        return this.type;
    }

    public String toString() {
        return String.format("%-50s   ", String.format("%s=(%s)%s", this.name != null ? this.name : this.oid.toString(), VarBind.getTypeName(this.type), this.variable));
    }

    public static String getTypeName(int syntax) {
        switch (syntax) {
            case 2: {
                return "Integer32";
            }
            case 4: {
                return "OCTET_STRING";
            }
            case 6: {
                return "OID";
            }
            case 67: {
                return "TimeTicks";
            }
            case 65: {
                return "Counter";
            }
            case 70: {
                return "Counter64";
            }
            case 130: {
                return "EndOfMibView";
            }
            case 66: {
                return "Gauge";
            }
            case 64: {
                return "IpAddress";
            }
            case 129: {
                return "NoSuchInstance";
            }
            case 128: {
                return "NoSuchObject";
            }
            case 5: {
                return "Null";
            }
            case 68: {
                return "Opaque";
            }
        }
        return "?" + syntax + "?";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VarBind clone() {
        try {
            return (VarBind)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return new VarBind(this.name, this.oid, this.type, this.variable);
        }
    }
}

