/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.protocols.snmp;

import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.protocols.snmp.SNMPException;
import com.bwanms.protocols.snmp.SNMPSession;
import com.bwanms.protocols.snmp.SNMPTrapListener;
import com.bwanms.protocols.snmp.SNMPTrapV1Listener;
import com.bwanms.protocols.snmp.impl.snmp4j.SNMP4JCommunityBasedSession;
import com.bwanms.protocols.snmp.impl.snmp4j.SNMP4JTrapListener;
import com.bwanms.protocols.snmp.impl.snmp4j.SNMP4JTrapV1Listener;
import java.io.IOException;

public class SNMPFactory {
    private SNMPFactory() {
    }

    public static SNMPSession createSession(SNMPManagementInterface agentInfo) throws SNMPException {
        SNMP4JCommunityBasedSession session = null;
        switch (agentInfo.getVersion()) {
            case 0: 
            case 1: {
                session = new SNMP4JCommunityBasedSession(agentInfo);
                break;
            }
        }
        return session;
    }

    public static SNMPTrapListener createTrapListener(String ipAddress, int port) throws IOException {
        return new SNMP4JTrapListener(ipAddress, port);
    }

    public static SNMPTrapListener createTrapListener(int port) throws IOException {
        return new SNMP4JTrapListener(port);
    }

    @Deprecated
    public static SNMPTrapV1Listener createSNMPTrapV1Listener(String ipAddress, int port) throws IOException {
        return new SNMP4JTrapV1Listener(ipAddress, port);
    }

    @Deprecated
    public static SNMPTrapV1Listener createSNMPTrapV1Listener(int port) throws IOException {
        return new SNMP4JTrapV1Listener(port);
    }
}

