/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.protocols.snmp;

import java.io.Serializable;

public class NullObject
implements Serializable {
    private int syntax = 5;

    public NullObject() {
    }

    public NullObject(int exceptionSyntax) {
        this.setSyntax(exceptionSyntax);
    }

    public int getSyntax() {
        return this.syntax;
    }

    public void setSyntax(int syntax) {
        if (syntax != 5 && !this.isExceptionSyntax(syntax)) {
            throw new IllegalArgumentException("Syntax " + syntax + " is incompatible with NullObject type");
        }
        this.syntax = syntax;
    }

    public String toString() {
        String str = "Null";
        switch (this.getSyntax()) {
            case 128: {
                str = "noSuchObject";
                break;
            }
            case 129: {
                str = "noSuchInstance";
                break;
            }
            case 130: {
                str = "endOfMibView";
            }
        }
        return str;
    }

    public boolean isException() {
        return this.isExceptionSyntax(this.syntax);
    }

    private boolean isExceptionSyntax(int syntax) {
        switch (syntax) {
            case 128: 
            case 129: 
            case 130: {
                return true;
            }
        }
        return false;
    }
}

