/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.plugin.impl;

import com.bwanms.util.JarResources;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginScanner {
    private static Logger logger = Logger.getLogger(PluginScanner.class);

    public static List<String> scanFolderForJaredTextResources(String pluginsDir, String resourceName) {
        return PluginScanner.scanFolderForJaredTextResources(new File(pluginsDir), resourceName);
    }

    public static List<String> scanFolderForJaredTextResources(File pluginsDir, String resourceName) {
        if (!pluginsDir.exists()) {
            logger.info((Object)(pluginsDir.getAbsolutePath() + " does not exist"));
            return new ArrayList<String>();
        }
        ArrayList<byte[]> resources = new ArrayList<byte[]>();
        PluginScanner.scanFolderForJarredResources(resourceName, resources, pluginsDir);
        ArrayList<String> ret = new ArrayList<String>();
        for (byte[] resource : resources) {
            ret.add(new String(resource));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scanFolderForJarredResources(String resourceName, ArrayList<byte[]> result, File pluginsDir) {
        logger.debug((Object)("Scanning: " + pluginsDir.getAbsolutePath()));
        try {
            File[] files = pluginsDir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isFile()) continue;
                    if (file.getName().toLowerCase().endsWith(".jar")) {
                        JarResources jarResources = new JarResources(file.getAbsolutePath());
                        byte[] resource = jarResources.getResource(resourceName);
                        if (resource == null) continue;
                        logger.info((Object)("Found [" + resourceName + "] in jar: " + file.getAbsolutePath()));
                        result.add(resource);
                        continue;
                    }
                    if (!file.getName().equalsIgnoreCase(resourceName)) continue;
                    if (file.canRead()) {
                        logger.info((Object)String.format("Found %s at %s", resourceName, file.getPath()));
                        long size = file.length();
                        byte[] b = new byte[(int)size];
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(file);
                            fis.read(b);
                            fis.close();
                            result.add(b);
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            logger.info((Object)("Exception reading from file " + file.getPath()));
                            continue;
                        }
                        finally {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                    }
                    logger.warn((Object)("Can't read from file " + file.getPath()));
                }
                for (File file : files) {
                    if (!file.isDirectory()) continue;
                    PluginScanner.scanFolderForJarredResources(resourceName, result, file);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

