/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.plugin.impl;

import com.bwanms.gui.Internationalizer;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExecutableExtension;
import com.bwanms.plugin.IExtension;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.plugin.IPluginDefinition;
import com.bwanms.plugin.impl.ConfigurationElement;
import com.bwanms.plugin.impl.Extension;
import com.bwanms.plugin.impl.ExtensionPoint;
import com.bwanms.plugin.impl.PluginDefinition;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionRegistryImpl
implements IExtensionRegistry,
Serializable {
    private static final long serialVersionUID = 1410390600297059598L;
    private static final Logger logger = Logger.getLogger(ExtensionRegistryImpl.class);
    private HashMap<String, ExtensionPoint> extensionPoints = new HashMap();
    private HashMap<String, ArrayList<Extension>> extensions = new HashMap();
    private HashSet<String> namespaces = new HashSet();
    private ArrayList<PluginDefinition> plugins = new ArrayList();
    private static boolean translated = false;

    @Override
    public IConfigurationElement[] getConfigurationElementsFor(String extensionPointId) {
        return this.getExtensionPoint(extensionPointId).getConfigurationElements();
    }

    @Override
    public IConfigurationElement[] getConfigurationElementsFor(String namespace, String name) {
        return this.getExtensionPoint(namespace, name).getConfigurationElements();
    }

    @Override
    public IConfigurationElement[] getConfigurationElementsFor(String namespace, String name, String extensionId) {
        return this.getExtensionPoint(namespace, name).getExtension(extensionId).getConfigurationElements();
    }

    @Override
    public IExtension getExtension(String extensionId) {
        for (ArrayList<Extension> extArray : this.extensions.values()) {
            for (Extension extension : extArray) {
                if (!extensionId.equals(extension.getUniqueIdentifier())) continue;
                return new ExtensionImpl(extension);
            }
        }
        return null;
    }

    @Override
    public IExtension getExtension(String extensionPointId, String extensionId) {
        ArrayList<Extension> extArray = this.extensions.get(extensionPointId);
        if (extArray != null) {
            for (Extension extension : extArray) {
                if (!extensionId.equals(extension.getUniqueIdentifier())) continue;
                return new ExtensionImpl(extension);
            }
        }
        return null;
    }

    @Override
    public IExtension getExtension(String namespace, String name, String extensionId) {
        return this.getExtension(ExtensionRegistryImpl.getExtensionPointUniqueId(namespace, name), extensionId);
    }

    @Override
    public IExtensionPoint getExtensionPoint(String extensionPointId) {
        ExtensionPoint extensionPoint = this.extensionPoints.get(extensionPointId);
        if (extensionPoint != null) {
            return new ExtensionPointImpl(extensionPoint);
        }
        return null;
    }

    @Override
    public IExtensionPoint getExtensionPoint(String namespace, String name) {
        return this.getExtensionPoint(ExtensionRegistryImpl.getExtensionPointUniqueId(namespace, name));
    }

    @Override
    public IExtensionPoint[] getExtensionPoints() {
        ArrayList<ExtensionPointImpl> ret = new ArrayList<ExtensionPointImpl>();
        for (ExtensionPoint extensionPoint : this.extensionPoints.values()) {
            ret.add(new ExtensionPointImpl(extensionPoint));
        }
        return ret.toArray(new IExtensionPoint[ret.size()]);
    }

    @Override
    public IExtensionPoint[] getExtensionPoints(String namespace) {
        ArrayList<ExtensionPointImpl> ret = new ArrayList<ExtensionPointImpl>();
        for (ExtensionPoint extensionPoint : this.extensionPoints.values()) {
            if (!namespace.equals(extensionPoint.getNamespace())) continue;
            ret.add(new ExtensionPointImpl(extensionPoint));
        }
        return ret.toArray(new IExtensionPoint[ret.size()]);
    }

    @Override
    public IExtension[] getExtensions(String namespace) {
        ArrayList<ExtensionImpl> ret = new ArrayList<ExtensionImpl>();
        for (ArrayList<Extension> extensionArray : this.extensions.values()) {
            for (Extension extension : extensionArray) {
                if (!namespace.equals(extension.getNamespace())) continue;
                ret.add(new ExtensionImpl(extension));
            }
        }
        return ret.toArray(new IExtension[ret.size()]);
    }

    List<Extension> getExtensionsForExtensionPoint(String extensionPointId) {
        ArrayList ret = this.extensions.get(extensionPointId);
        return ret == null ? new ArrayList() : ret;
    }

    @Override
    public String[] getNamespaces() {
        return this.namespaces.toArray(new String[this.namespaces.size()]);
    }

    @Override
    public IPluginDefinition[] getPlugins() {
        return this.plugins.toArray(new PluginDefinition[this.plugins.size()]);
    }

    static String getExtensionPointUniqueId(String namespace, String name) {
        return "".equals(namespace) ? name : namespace + "." + name;
    }

    private void addExtensionPoint(ExtensionPoint extensionPoint) {
        this.extensionPoints.put(extensionPoint.getUniqueIdentifier(), extensionPoint);
    }

    private void addExtension(Extension extension) {
        ArrayList<Extension> extensionPointExtensions = this.extensions.get(extension.getExtensionPointUniqueIdentifier());
        if (extensionPointExtensions == null) {
            extensionPointExtensions = new ArrayList();
            this.extensions.put(extension.getExtensionPointUniqueIdentifier(), extensionPointExtensions);
        }
        extensionPointExtensions.add(extension);
    }

    private void addNamespace(String namespace) {
        if (namespace != null) {
            this.namespaces.add(namespace);
        }
    }

    public void configure(List<String> pluginFiles) {
        for (String pluginFile : pluginFiles) {
            try {
                this.parseFile(pluginFile);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    public void configureFromStrings(List<String> pluginStrings) {
        for (String pluginFile : pluginStrings) {
            try {
                this.parseString(pluginFile);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    private void translatePlugins() {
        Internationalizer ddiI18n = Internationalizer.getInternationalizer("com.bwanms.ddi");
        for (PluginDefinition plugin : this.plugins) {
            plugin.setNameTranslated(ddiI18n.translateString(plugin.getName()));
        }
    }

    private void parseFile(String xmlFile) throws Exception {
        FileInputStream fin = null;
        try {
            logger.info((Object)("Processing: " + xmlFile));
            fin = new FileInputStream(xmlFile);
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser parser = saxParserFactory.newSAXParser();
            parser.parse((InputStream)fin, (DefaultHandler)new PluginHanlder());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
    }

    private void parseString(String string) throws Exception {
        ByteArrayInputStream fin = null;
        try {
            fin = new ByteArrayInputStream(string.getBytes());
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser parser = saxParserFactory.newSAXParser();
            parser.parse((InputStream)fin, (DefaultHandler)new PluginHanlder());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
    }

    private class ExtensionPointImpl
    implements IExtensionPoint {
        private ExtensionPoint extensionPoint;

        public ExtensionPointImpl(ExtensionPoint extensionPoint) {
            this.extensionPoint = extensionPoint;
        }

        public IConfigurationElement[] getConfigurationElements() {
            ArrayList<ConfigurationElementImpl> ret = new ArrayList<ConfigurationElementImpl>();
            ArrayList regExtensions = (ArrayList)ExtensionRegistryImpl.this.extensions.get(this.getUniqueIdentifier());
            if (regExtensions == null) {
                return new IConfigurationElement[0];
            }
            for (Extension extension : regExtensions) {
                for (ConfigurationElement element : extension.getConfigurationElements()) {
                    ret.add(new ConfigurationElementImpl(element, new ExtensionImpl(extension)));
                }
            }
            return ret.toArray(new IConfigurationElement[ret.size()]);
        }

        public String getNamespace() {
            return this.extensionPoint.getNamespace();
        }

        public IExtension getExtension(String extensionId) {
            ArrayList retExt = (ArrayList)ExtensionRegistryImpl.this.extensions.get(this.getUniqueIdentifier());
            if (retExt != null) {
                for (Extension extension : retExt) {
                    if (!extensionId.equals(extension.getUniqueIdentifier())) continue;
                    return new ExtensionImpl(extension);
                }
            }
            return null;
        }

        public IExtension[] getExtensions() {
            ArrayList retExt = (ArrayList)ExtensionRegistryImpl.this.extensions.get(this.getUniqueIdentifier());
            ArrayList<ExtensionImpl> ret = new ArrayList<ExtensionImpl>();
            if (retExt != null) {
                for (Extension extension : retExt) {
                    ret.add(new ExtensionImpl(extension));
                }
            }
            return ret.toArray(new IExtension[ret.size()]);
        }

        public String getLabel() {
            return this.extensionPoint.getLabel();
        }

        public String getSchemaReference() {
            return this.extensionPoint.getSchemaReference();
        }

        public String getSimpleIdentifier() {
            return this.extensionPoint.getSimpleIdentifier();
        }

        public String getUniqueIdentifier() {
            return this.extensionPoint.getUniqueIdentifier();
        }

        public boolean isValid() {
            return true;
        }
    }

    private class ConfigurationElementImpl
    implements IConfigurationElement {
        private ConfigurationElement element;
        private Object parent;

        public ConfigurationElementImpl(ConfigurationElement element, Object parent) {
            this.element = element;
            this.parent = parent;
        }

        public Object createExecutableExtension(String name) {
            try {
                Object exec;
                String className = this.getAttribute(name);
                String data = null;
                if (className.indexOf(58) != -1) {
                    data = className.substring(className.indexOf(58) + 1);
                    className = className.substring(0, className.indexOf(58) - 1);
                }
                if ((exec = Class.forName(className).newInstance()) instanceof IExecutableExtension) {
                    ((IExecutableExtension)exec).setInitializationData(this, name, data);
                }
                return exec;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String getAttribute(String name) {
            return this.element.getAttribute(name);
        }

        public String getAttributeAsIs(String name) {
            return this.element.getAttributeAsIs(name);
        }

        public String[] getAttributeNames() {
            return this.element.getAttributeNames();
        }

        public IConfigurationElement[] getChildren() {
            ConfigurationElement[] children = this.element.getChildren();
            IConfigurationElement[] ret = new IConfigurationElement[this.element.getChildren().length];
            for (int i = 0; i < children.length; ++i) {
                ret[i] = new ConfigurationElementImpl(children[i], this);
            }
            return ret;
        }

        public IConfigurationElement[] getChildren(String name) {
            ConfigurationElement[] children = this.element.getChildren(name);
            IConfigurationElement[] ret = new IConfigurationElement[this.element.getChildren().length];
            for (int i = 0; i < children.length; ++i) {
                ret[i] = new ConfigurationElementImpl(children[i], this);
            }
            return ret;
        }

        public IExtension getDeclaringExtension() {
            if (this.parent instanceof IConfigurationElement) {
                return ((IConfigurationElement)this.parent).getDeclaringExtension();
            }
            return (IExtension)this.parent;
        }

        public String getName() {
            return this.element.getName();
        }

        public Object getParent() {
            return this.parent;
        }

        public String getValue() {
            return this.element.getValue();
        }

        public String getValueAsIs() {
            return this.element.getValueAsIs();
        }

        public String getNamespace() {
            return this.element.getNamespace();
        }

        public boolean isValid() {
            return true;
        }
    }

    private class ExtensionImpl
    implements IExtension {
        private Extension extension;

        public ExtensionImpl(Extension extension) {
            this.extension = extension;
        }

        public IConfigurationElement[] getConfigurationElements() {
            ArrayList<ConfigurationElementImpl> ret = new ArrayList<ConfigurationElementImpl>();
            for (ConfigurationElement element : this.extension.getConfigurationElements()) {
                ret.add(new ConfigurationElementImpl(element, this));
            }
            return ret.toArray(new IConfigurationElement[ret.size()]);
        }

        public String getNamespace() {
            return this.extension.getNamespace();
        }

        public String getExtensionPointUniqueIdentifier() {
            return this.extension.getExtensionPointUniqueIdentifier();
        }

        public String getLabel() {
            return this.extension.getLabel();
        }

        public String getSimpleIdentifier() {
            return this.extension.getSimpleIdentifier();
        }

        public String getUniqueIdentifier() {
            return this.extension.getUniqueIdentifier();
        }

        public boolean isValid() {
            return true;
        }
    }

    private class PluginHanlder
    extends DefaultHandler {
        private Stack<Object> currentStack = new Stack();
        private String namespace = null;

        private PluginHanlder() {
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!"plugin".equals(qName) && !"extension-point".equals(qName)) {
                this.currentStack.pop();
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("plugin".equals(qName)) {
                this.processPlugin(uri, localName, qName, attributes);
            } else if ("extension-point".equals(qName)) {
                if (this.currentStack.size() > 0) {
                    throw new RuntimeException("extension-point element cannot be nested");
                }
                this.processExtensionPoint(uri, localName, qName, attributes);
            } else if ("extension".equals(qName)) {
                if (this.currentStack.size() > 0) {
                    throw new RuntimeException("extension element cannot be nested");
                }
                this.processExtension(uri, localName, qName, attributes);
            } else {
                if (this.currentStack.isEmpty()) {
                    throw new RuntimeException("un-nested configuration element found: " + qName);
                }
                this.processConfigurationElement(uri, localName, qName, attributes);
            }
        }

        private void processPlugin(String uri, String localName, String qName, Attributes attributes) {
            String module;
            String version;
            String name;
            this.namespace = attributes.getValue("id");
            if (this.namespace == null) {
                this.namespace = "";
            }
            if ((name = attributes.getValue("name")) == null) {
                name = "";
            }
            if ((version = attributes.getValue("version")) == null) {
                version = "";
            }
            String info = attributes.getValue("info");
            if (version == null) {
                version = "";
            }
            if ((module = attributes.getValue("module")) == null) {
                module = "";
            }
            ExtensionRegistryImpl.this.plugins.add(new PluginDefinition(this.namespace, name, version, info, module, name));
            ExtensionRegistryImpl.this.addNamespace(this.namespace);
        }

        private void processExtensionPoint(String uri, String localName, String qName, Attributes attributes) {
            ExtensionPoint extensionPoint = new ExtensionPoint();
            extensionPoint.setName(attributes.getValue("name"));
            extensionPoint.setSimpleIdentifier(attributes.getValue("id"));
            extensionPoint.setNamespace(this.namespace);
            ExtensionRegistryImpl.this.addExtensionPoint(extensionPoint);
            logger.debug((Object)("Extension-point: " + extensionPoint.getUniqueIdentifier()));
        }

        private void processExtension(String uri, String localName, String qName, Attributes attributes) {
            Extension extension = new Extension();
            extension.setExtensionPointUniqueIdentifier(attributes.getValue("point"));
            extension.setSimpleIdentifier(attributes.getValue("id"));
            extension.setNamespace(this.namespace);
            ExtensionRegistryImpl.this.addExtension(extension);
            this.currentStack.push(extension);
            logger.debug((Object)("Extension: " + extension.getUniqueIdentifier()));
        }

        private void processConfigurationElement(String uri, String localName, String qName, Attributes attributes) {
            ConfigurationElement element = new ConfigurationElement();
            element.setName(qName);
            element.setNamespace(this.namespace);
            for (int i = 0; i < attributes.getLength(); ++i) {
                element.setAttribute(attributes.getQName(i), attributes.getValue(i));
            }
            Object parent = this.currentStack.peek();
            if (parent instanceof Extension) {
                ((Extension)parent).addConfigurationElement(element);
                logger.debug((Object)("Element: " + ((Extension)parent).getUniqueIdentifier() + " " + element.getName()));
            } else if (parent instanceof ConfigurationElement) {
                ((ConfigurationElement)parent).addConfigurationElement(element);
                logger.debug((Object)("Element: " + ((ConfigurationElement)parent).getName() + " " + element.getName()));
            }
            this.currentStack.push(element);
        }
    }
}

