/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.platform.local;

import com.bwanms.platform.local.LocalMessageDispatch;
import com.bwanms.platform.local.LocalMessageListener;
import com.bwanms.platform.local.LocalMessagingSupport;
import com.bwanms.platform.local.SimpleObjectMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalTopicMessaging
extends LocalMessagingSupport {
    private static final Logger log = Logger.getLogger(LocalTopicMessaging.class);
    private HashMap<String, ArrayList<LocalMessageListener>> listeners = new HashMap();

    public LocalTopicMessaging() {
        super("LocalTopicMessaging");
    }

    public void createTopic(String topicName) {
        if (this.listeners.get(topicName) != null) {
            throw new RuntimeException("Topic already defined: " + topicName);
        }
        log.debug((Object)("Created TOPIC " + topicName));
        this.listeners.put(topicName, new ArrayList());
    }

    public void destroyTopic(String topicName) {
        this.listeners.remove(topicName);
    }

    public void addTopicListener(String topicName, MessageListener listener, String messageSelectorKey, String messageSelectorValue) {
        ArrayList<LocalMessageListener> regListeners = this.listeners.get(topicName);
        if (regListeners == null) {
            throw new RuntimeException("No such topic: " + topicName);
        }
        regListeners.add(new LocalMessageListener(listener, messageSelectorKey, messageSelectorValue));
    }

    public void removeTopicListener(MessageListener listener) {
        for (ArrayList<LocalMessageListener> regListeners : this.listeners.values()) {
            Iterator<LocalMessageListener> i = regListeners.iterator();
            while (i.hasNext()) {
                if (i.next().getListener() != listener) continue;
                i.remove();
            }
        }
    }

    public void publish(String topicName, Serializable message, Map<String, String> stringMessageProperties) {
        ArrayList<LocalMessageListener> regListeners = this.listeners.get(topicName);
        if (regListeners == null) {
            throw new RuntimeException("No such topic: " + topicName);
        }
        SimpleObjectMessage msg = new SimpleObjectMessage();
        if (stringMessageProperties != null) {
            for (Map.Entry<String, String> entry : stringMessageProperties.entrySet()) {
                msg.setStringProperty(entry.getKey(), entry.getValue());
            }
        }
        msg.setObject(message);
        ArrayList<LocalMessageDispatch> dispatches = new ArrayList<LocalMessageDispatch>();
        for (LocalMessageListener listener : regListeners) {
            dispatches.add(new LocalMessageDispatch((Message)msg, listener));
        }
        this.addPendingDispatches(dispatches);
    }
}

