/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.platform.local;

import com.bwanms.platform.local.LocalMessageDispatch;
import com.bwanms.platform.local.LocalMessageListener;
import com.bwanms.platform.local.LocalMessagingSupport;
import com.bwanms.platform.local.SimpleObjectMessage;
import com.bwanms.util.PlatformConfiguration;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.log4j.Logger;

class LocalQueueMessaging
extends LocalMessagingSupport {
    private static final Logger log = Logger.getLogger(LocalQueueMessaging.class);
    private TreeSet<String> queues = new TreeSet();
    private HashMap<String, LocalMessageListener> listeners = new HashMap();

    public LocalQueueMessaging() {
        super("LocalQueueMessaging");
    }

    public void createQueue(String queueName) {
        if (this.queues.contains(queueName)) {
            throw new RuntimeException("Queue already defined: " + queueName);
        }
        log.debug((Object)("Created QUEUE " + queueName));
        this.queues.add(queueName);
    }

    public void destroyQueue(String queueName) {
        this.queues.remove(queueName);
        this.listeners.remove(queueName);
    }

    public void setQueueListener(String queueName, MessageListener listener) {
        if (this.listeners.get(queueName) != null) {
            throw new RuntimeException("Queue is already listened to!");
        }
        this.listeners.put(queueName, new LocalMessageListener(listener, null, null));
    }

    public void removeQueueListener(MessageListener listener) {
        Iterator<String> qi = this.listeners.keySet().iterator();
        while (qi.hasNext()) {
            if (this.listeners.get(qi.next()).getListener() != listener) continue;
            qi.remove();
            return;
        }
    }

    public void send(String queueName, Serializable message) {
        LocalMessageListener regListener = this.listeners.get(queueName);
        if (!PlatformConfiguration.isLocalPlatform() && !this.queues.contains(queueName)) {
            throw new RuntimeException("No such QUEUE: " + queueName);
        }
        if (regListener == null) {
            return;
        }
        SimpleObjectMessage msg = new SimpleObjectMessage();
        msg.setObject(message);
        this.addPendingDispatch(new LocalMessageDispatch((Message)msg, regListener));
    }
}

