/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.platform.local;

import com.bwanms.platform.local.LocalMessageDispatch;
import com.bwanms.util.ExecutorUtils;
import com.bwanms.util.NamedThreadFactory;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LocalMessagingSupport {
    private static final Logger log = Logger.getLogger(LocalMessagingSupport.class);
    private ExecutorService slaves = Executors.newFixedThreadPool(10, new NamedThreadFactory(this.getClass().getName()));
    private String threadPoolName;
    private boolean shouldStop = false;
    private static final int THREAD_COUNT = 10;

    public LocalMessagingSupport(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }

    public final void stop() {
        this.shouldStop = true;
        ExecutorUtils.shutdownAndWait(this.threadPoolName, this.slaves);
    }

    protected final void addPendingDispatch(LocalMessageDispatch dispatch) {
        this.submitDispatch(dispatch);
    }

    protected final void addPendingDispatches(List<LocalMessageDispatch> dispatches) {
        for (LocalMessageDispatch dispatch : dispatches) {
            this.submitDispatch(dispatch);
        }
    }

    private void submitDispatch(final LocalMessageDispatch dispatch) {
        this.slaves.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (!LocalMessagingSupport.this.shouldStop) {
                    log.debug((Object)("MessagingThread woke: [" + LocalMessagingSupport.this.threadPoolName + "]-" + Thread.currentThread().getName()));
                    dispatch.dispatch();
                }
            }
        });
    }
}

