/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.platform.local;

import com.bwanms.platform.Messaging;
import com.bwanms.platform.local.LocalQueueMessaging;
import com.bwanms.platform.local.LocalTopicMessaging;
import java.io.Serializable;
import java.util.Map;
import javax.jms.MessageListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalMessaging
implements Messaging {
    static final Logger logger = Logger.getLogger(LocalMessaging.class);
    private LocalTopicMessaging topicMessaging = new LocalTopicMessaging();
    private LocalQueueMessaging queueMessaging = new LocalQueueMessaging();

    LocalMessaging() {
    }

    @Override
    public void createTopic(String topicName) {
        this.topicMessaging.createTopic(topicName);
    }

    @Override
    public void addTopicListener(String topicName, MessageListener listener) {
        this.addTopicListener(topicName, listener, null, null, false);
    }

    @Override
    public void addTopicListener(String topicName, MessageListener listener, String messageSelectorKey, String messageSelectorValue, boolean noLocal) {
        this.topicMessaging.addTopicListener(topicName, listener, messageSelectorKey, messageSelectorValue);
    }

    @Override
    public void removeTopicListener(MessageListener listener) {
        this.topicMessaging.removeTopicListener(listener);
    }

    @Override
    public void publish(String topicName, Serializable message, Map<String, String> stringMessageProperties) {
        this.topicMessaging.publish(topicName, message, stringMessageProperties);
    }

    @Override
    public void publish(String topicName, Serializable message) {
        this.publish(topicName, message, null);
    }

    @Override
    public void destroyTopic(String topicName) {
        this.topicMessaging.destroyTopic(topicName);
    }

    @Override
    public void cleanup() {
        this.topicMessaging.stop();
        this.queueMessaging.stop();
    }

    @Override
    public void createQueue(String queueName) {
        this.queueMessaging.createQueue(queueName);
    }

    @Override
    public void setQueueListener(String queueName, MessageListener listener) {
        this.queueMessaging.setQueueListener(queueName, listener);
    }

    @Override
    public void removeQueueListener(MessageListener listener) {
        this.queueMessaging.removeQueueListener(listener);
    }

    @Override
    public void send(String queueName, Serializable message) {
        this.queueMessaging.send(queueName, message);
    }

    @Override
    public void sendNonDurable(String queueName, Serializable message, long ttl) {
        this.send(queueName, message);
    }

    @Override
    public void sendWithReplyRequest(String queueName, Serializable message, MessageListener replyRequestor) {
        throw new UnsupportedOperationException("Local implementation does not support this opperation");
    }

    @Override
    public void destroyQueue(String queueName) {
        this.queueMessaging.destroyQueue(queueName);
    }
}

