/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.platform.local;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;

class LocalMessageListener
implements MessageListener {
    private static long idSequence = 0L;
    private MessageListener listener;
    private Long id;
    private String messageSelectorKey;
    private String messageSelectorValue;

    private static synchronized Long nextId() {
        return idSequence++;
    }

    public LocalMessageListener(MessageListener listener, String messageSelectorKey, String messageSelectorValue) {
        this.listener = listener;
        this.id = LocalMessageListener.nextId();
        this.messageSelectorKey = messageSelectorKey;
        this.messageSelectorValue = messageSelectorValue;
    }

    public Long getId() {
        return this.id;
    }

    public void onMessage(Message message) {
        try {
            if (this.messageSelectorValue == null || this.messageSelectorValue.equals("") || this.messageSelectorValue.equals(message.getStringProperty(this.messageSelectorKey))) {
                this.listener.onMessage(message);
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public MessageListener getListener() {
        return this.listener;
    }
}

