/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.platform.jboss;

import com.bwanms.platform.Lookup;
import com.bwanms.platform.Messaging;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossPlatformUtil
implements Messaging,
Lookup {
    private static final transient Logger log = Logger.getLogger(JBossPlatformUtil.class);
    Map<MessageListener, TopicSubscriber> subscribers;
    Map<MessageListener, QueueReceiver> receivers;
    Map<String, QueueReceiver> queueNameToReceiverMap;
    private Context ctx;
    private ConnectionFactory factory;
    private TopicConnection topicConnection;
    private TopicSession topicSession;
    private QueueConnection queueConnection;
    private QueueSession queueSession;

    public JBossPlatformUtil(Context initialContext, String connectionFactoryJNDI) {
        try {
            this.ctx = initialContext;
            this.factory = (ConnectionFactory)this.ctx.lookup(connectionFactoryJNDI);
            this.subscribers = new HashMap<MessageListener, TopicSubscriber>();
            this.topicConnection = ((TopicConnectionFactory)this.factory).createTopicConnection();
            this.topicSession = this.topicConnection.createTopicSession(false, 1);
            this.topicConnection.start();
            this.receivers = new HashMap<MessageListener, QueueReceiver>();
            this.queueNameToReceiverMap = new HashMap<String, QueueReceiver>();
            this.queueConnection = ((QueueConnectionFactory)this.factory).createQueueConnection();
            this.queueSession = this.queueConnection.createQueueSession(false, 1);
            this.queueConnection.start();
            log.info((Object)"topic connection started");
            log.info((Object)("MESSAGING SUBSySTEM INITIALIZED on " + connectionFactoryJNDI));
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void createTopic(String topicName) {
        try {
            TemporaryTopic topic = this.topicSession.createTemporaryTopic();
            this.bind(topicName, topic);
            log.info((Object)("Bound topic '" + topicName + "' on JNDI"));
        }
        catch (JMSException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void addTopicListener(String topicName, MessageListener listener, String messageSelectorKey, String messageSelectorValue, boolean noLocal) {
        try {
            Topic topic = (Topic)this.ctx.lookup(topicName);
            String messageSelector = null;
            if (messageSelectorValue != null && !messageSelectorValue.equals("")) {
                StringBuilder sb = new StringBuilder(messageSelectorKey);
                sb.append(" = '");
                sb.append(messageSelectorValue);
                sb.append("'");
                messageSelector = sb.toString();
            }
            TopicSubscriber receiver = this.topicSession.createSubscriber(topic, messageSelector, noLocal);
            receiver.setMessageListener(listener);
            this.subscribers.put(listener, receiver);
        }
        catch (NamingException e) {
            log.error((Object)e, (Throwable)e);
        }
        catch (JMSException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void addTopicListener(String topicName, MessageListener listener) {
        this.addTopicListener(topicName, listener, null, null, false);
    }

    @Override
    public void removeTopicListener(MessageListener listener) {
        try {
            this.subscribers.remove(listener).close();
            log.debug((Object)("removed topic listener" + listener));
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(String topicName, Serializable message, Map<String, String> stringMessageProperties) {
        TopicPublisher publisher = null;
        try {
            log.debug((Object)("PUBLISHING MESSAGE" + message + " ON TOPIC " + topicName));
            Topic topic = (Topic)this.ctx.lookup(topicName);
            publisher = this.topicSession.createPublisher(topic);
            ObjectMessage objectMessage = this.topicSession.createObjectMessage();
            objectMessage.setObject(message);
            if (stringMessageProperties != null) {
                for (Map.Entry<String, String> entry : stringMessageProperties.entrySet()) {
                    objectMessage.setStringProperty(entry.getKey(), entry.getValue());
                }
            }
            publisher.publish((Message)objectMessage);
            log.debug((Object)("MESSAGE " + message + " PUBLISED ON TOPIC " + topicName));
        }
        catch (NamingException e) {
            log.error((Object)e, (Throwable)e);
        }
        catch (JMSException e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            if (publisher != null) {
                try {
                    publisher.close();
                }
                catch (JMSException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    @Override
    public void publish(String topicName, Serializable message) {
        this.publish(topicName, message, null);
    }

    @Override
    public void destroyTopic(String topicName) {
        try {
            this.ctx.unbind(topicName);
            log.info((Object)("topic '" + topicName + "' destroyed"));
        }
        catch (NamingException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void cleanup() {
        try {
            this.topicConnection.close();
            this.topicSession.close();
            log.info((Object)"topci connection and session closed");
        }
        catch (JMSException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public Object lookup(String name) {
        try {
            return this.ctx.lookup(name);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void bind(String name, Object object) {
        try {
            try {
                Util.rebind((Context)this.ctx, (String)name, (Object)object);
                log.debug((Object)("Bound(serializable) name: " + name + " with " + object.getClass().getName()));
            }
            catch (Throwable e) {
                log.debug((Object)("BindING(non-serializable) name: " + name + " with " + object.getClass().getName()));
                Name fullName = this.ctx.getNameParser("").parse(name);
                NonSerializableFactory.rebind((Name)fullName, (Object)object, (boolean)true);
                log.debug((Object)("Bound(non-serializable) name: " + name + " with " + object.getClass().getName()));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unbind(String name) {
        try {
            this.ctx.unbind(name);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createQueue(String queueName) {
        try {
            TemporaryQueue queue = this.queueSession.createTemporaryQueue();
            this.bind(queueName, queue);
            log.debug((Object)("Created Queue " + queueName));
        }
        catch (JMSException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void setQueueListener(String queueName, MessageListener listener) {
        if (this.queueNameToReceiverMap.containsKey(queueName)) {
            throw new RuntimeException("Illegal operation. Cannot add another listener to queue " + queueName);
        }
        try {
            Queue queue = (Queue)this.ctx.lookup(queueName);
            QueueReceiver receiver = this.queueSession.createReceiver(queue);
            receiver.setMessageListener(listener);
            this.receivers.put(listener, receiver);
        }
        catch (NamingException e) {
            log.error((Object)e, (Throwable)e);
        }
        catch (JMSException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void removeQueueListener(MessageListener listener) {
        try {
            QueueReceiver receiver = this.receivers.remove(listener);
            if (receiver != null) {
                receiver.close();
            } else {
                log.warn((Object)"Attempted to close non-listening listener");
            }
        }
        catch (JMSException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(String queueName, Serializable message) {
        QueueSender sender = null;
        try {
            log.debug((Object)("SENDING MESSAGE " + message + " ON QUEUE " + queueName));
            Queue queue = (Queue)this.ctx.lookup(queueName);
            sender = this.queueSession.createSender(queue);
            ObjectMessage objectMessage = this.queueSession.createObjectMessage();
            objectMessage.setObject(message);
            sender.send((Message)objectMessage);
            log.debug((Object)("SENT MESSAGE " + message + " ON QUEUE " + queueName));
        }
        catch (NamingException e) {
            log.error((Object)e, (Throwable)e);
        }
        catch (JMSException e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            if (sender != null) {
                try {
                    sender.close();
                }
                catch (JMSException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendNonDurable(String queueName, Serializable message, long ttl) {
        QueueSender sender = null;
        try {
            log.debug((Object)("SENDING NON DURABLE MESSAGE " + message + " ON QUEUE " + queueName));
            Queue queue = (Queue)this.ctx.lookup(queueName);
            sender = this.queueSession.createSender(queue);
            sender.setDeliveryMode(1);
            sender.setTimeToLive(ttl);
            ObjectMessage objectMessage = this.queueSession.createObjectMessage();
            objectMessage.setObject(message);
            sender.send((Message)objectMessage);
            log.debug((Object)("SENT NON DURABLE MESSAGE " + message + " ON QUEUE " + queueName));
        }
        catch (NamingException e) {
            log.error((Object)e, (Throwable)e);
        }
        catch (JMSException e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            if (sender != null) {
                try {
                    sender.close();
                }
                catch (JMSException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    @Override
    public void sendWithReplyRequest(String queueName, Serializable message, MessageListener replyRequestor) {
        try {
            log.debug((Object)("SENDING WITH REPLY REQUEST MESSAGE " + message + " ON QUEUE " + queueName));
            Queue queue = (Queue)this.ctx.lookup(queueName);
            QueueSender sender = this.queueSession.createSender(queue);
            ObjectMessage objectMessage = this.queueSession.createObjectMessage();
            objectMessage.setObject(message);
            TemporaryQueue temporaryQueue = this.queueSession.createTemporaryQueue();
            objectMessage.setJMSReplyTo((Destination)temporaryQueue);
            QueueReceiver tempReceiver = this.queueSession.createReceiver((Queue)temporaryQueue);
            tempReceiver.setMessageListener(replyRequestor);
            sender.send((Message)objectMessage);
            log.debug((Object)("SENT WITH REPLY REQUEST MESSAGE " + message + " ON QUEUE " + queueName));
        }
        catch (NamingException e) {
            log.error((Object)e, (Throwable)e);
        }
        catch (JMSException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void destroyQueue(String queueName) {
        try {
            this.ctx.unbind(queueName);
            log.info((Object)("queue '" + queueName + "' destroyed"));
        }
        catch (NamingException e) {
            log.error((Object)e, (Throwable)e);
        }
    }
}

