/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.platform.jboss;

import com.bwanms.platform.Lookup;
import com.bwanms.platform.Messaging;
import com.bwanms.platform.Platform;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.platform.jboss.JBossPlatformUtil;
import java.net.InetAddress;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class JBossPlatformFactory
extends PlatformFactory {
    private static final Logger log = Logger.getLogger(JBossPlatformFactory.class);
    private static Platform applicationLayerPlatform;
    private static Platform defaultMediationLayerPlatform;

    public void resetImpl() {
        if (!JBossPlatformFactory.runningAsAppServer()) {
            applicationLayerPlatform = null;
        }
    }

    public Platform getApplicationLayerPlatformImpl() {
        if (applicationLayerPlatform == null) {
            applicationLayerPlatform = JBossPlatformFactory.runningAsMedServer() ? this.getPlatform(JBossPlatformFactory.getAppServerPartitionName()) : this.getPlatform(null);
        }
        return applicationLayerPlatform;
    }

    public Platform getMediationLayerPlatformImpl(String partitionName) {
        if (partitionName == null || "".equals(partitionName)) {
            if (JBossPlatformFactory.runningAsMedServer()) {
                if (defaultMediationLayerPlatform == null) {
                    defaultMediationLayerPlatform = this.getPlatform(null);
                }
                return defaultMediationLayerPlatform;
            }
            return this.getApplicationLayerPlatformImpl();
        }
        return this.getPlatform(partitionName);
    }

    private Platform getPlatform(String partitionName) {
        InitialContext ctxt = this.getInitialContext(partitionName);
        String connectionFactory = partitionName == null && !JBossPlatformFactory.runningAsClient() ? "java:/ConnectionFactory" : "UIL2ConnectionFactory";
        final JBossPlatformUtil util = new JBossPlatformUtil(ctxt, connectionFactory);
        return new Platform(){

            public Messaging getMessaging() {
                return util;
            }

            public Lookup getLookup() {
                return util;
            }

            public String getIPAddress() {
                try {
                    return InetAddress.getByName(System.getProperty("com.dorado.local.host")).getHostAddress();
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            }
        };
    }

    private InitialContext getInitialContext(String partitionName) {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        if (partitionName == null) {
            partitionName = System.getProperty("jnp.partitionName");
        }
        if (partitionName == null) {
            partitionName = System.getProperty("oware.client.partition.name");
        }
        if (partitionName == null) {
            partitionName = System.getProperty("PART_NAME");
        }
        env.put("jnp.partitionName", partitionName);
        try {
            if (System.getProperty("com.dorado.local.host") == null || "".equals(System.getProperty("com.dorado.local.host"))) {
                System.setProperty("com.dorado.local.host", InetAddress.getLocalHost().getHostName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (JBossPlatformFactory.runningAsClient()) {
            String SERVER_URL = System.getProperty("OWARE.CONTEXT.SERVER.URL");
            if (null == SERVER_URL) {
                env.setProperty("jnp.disableDiscovery", "false");
            } else {
                env.put("java.naming.provider.url", SERVER_URL);
                env.setProperty("jnp.disableDiscovery", "true");
            }
        }
        try {
            return new InitialContext(env);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getAppServerPartitionName() {
        return System.getProperty("com.dorado.external.application.partition");
    }

    private static boolean runningAsAppServer() {
        return System.getProperty("oware.server.type", "").equalsIgnoreCase("appserver");
    }

    private static boolean runningAsMedServer() {
        return System.getProperty("oware.server.type", "").equalsIgnoreCase("medserver");
    }

    private static boolean runningAsClient() {
        return !JBossPlatformFactory.runningAsAppServer() && !JBossPlatformFactory.runningAsMedServer();
    }

    static {
        log.info((Object)"--------------------------------------------------");
        log.info((Object)"JBOSS Platform: ");
        log.info((Object)"--------------------------------------------------");
        log.info((Object)("\tAppServer: " + JBossPlatformFactory.runningAsAppServer()));
        log.info((Object)("\tMedServer: " + JBossPlatformFactory.runningAsMedServer()));
        log.info((Object)("\tClient   : " + JBossPlatformFactory.runningAsClient()));
        log.info((Object)"--------------------------------------------------");
    }
}

