/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.platform;

import java.io.File;

public class PlatformRuntime {
    public static OS getOS() {
        return OS.getOS();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS {
        WINDOWS(1){

            String[] shellCmd(String args) {
                String[] cmd = new String[]{"cmd.exe", "/C", args};
                return cmd;
            }
        }
        ,
        SOLARIS(2){

            String[] shellCmd(String args) {
                String[] cmd = new String[]{"/bin/sh", "-c", args};
                return cmd;
            }
        }
        ,
        LINUX(3){

            String[] shellCmd(String args) {
                String[] cmd = new String[3];
                return cmd;
            }
        };

        private static OS os;
        private String osName = "";
        private String osVersion = "";
        private int osID = -1;

        private OS(int osID) {
            this.osID = osID;
        }

        private boolean isOSInfoLoaded() {
            return this.osName == null || this.osName.length() == 0;
        }

        private void loadOSInfo() {
            this.osName = System.getProperty("os.name", "Unknown");
            this.osVersion = System.getProperty("os.version", "Unknown");
        }

        public static OS getOS() {
            if (!os.isOSInfoLoaded()) {
                os.loadOSInfo();
            }
            return os;
        }

        public int getID() {
            return this.osID;
        }

        public String getName() {
            return this.osName;
        }

        public String getVersion() {
            return this.osVersion;
        }

        abstract String[] shellCmd(String var1);

        public boolean runShellCmd(String cmd) {
            try {
                Process proc = Runtime.getRuntime().exec(this.shellCmd(cmd));
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException("Shell command exec failed : " + cmd, e);
            }
        }

        public boolean runShellCmd(String cmd, String startupDir) {
            try {
                Runtime.getRuntime().exec(this.shellCmd(cmd), null, new File(startupDir));
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException("Shell command exec failed : " + cmd, e);
            }
        }

        static {
            os = null;
            String _osName = System.getProperty("os.name", "Unknown");
            if (_osName.startsWith("Windows")) {
                os = WINDOWS;
            } else if (_osName.startsWith("Solaris") || _osName.startsWith("SunOS")) {
                os = SOLARIS;
            } else if (_osName.startsWith("Linux")) {
                os = LINUX;
            }
        }
    }
}

