/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.persistence.usertypes;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class EscapedString
implements UserType {
    private static final String ESCAPE_STRING = "<empty>";
    private static final char QUOTING_CHAR = '\"';
    private static final int[] TYPES = new int[]{12};

    public int[] sqlTypes() {
        return TYPES;
    }

    public Class returnedClass() {
        return String.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null) {
            return false;
        }
        return x.equals(y);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String dbValue = (String)Hibernate.STRING.nullSafeGet(rs, names[0]);
        if (dbValue != null) {
            return this.unescape(dbValue);
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value != null) {
            String v = this.escape((String)value);
            Hibernate.STRING.nullSafeSet(st, (Object)v, index);
        } else {
            Hibernate.STRING.nullSafeSet(st, value, index);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        return new String((String)value);
    }

    public boolean isMutable() {
        return false;
    }

    private String escape(String string) {
        return "".equals(string) ? ESCAPE_STRING : string;
    }

    private Object unescape(String string) throws HibernateException {
        return ESCAPE_STRING.equals(string) ? "" : string;
    }

    public Object replace(Object arg0, Object arg1, Object arg2) throws HibernateException {
        return this.deepCopy(arg0);
    }

    public Object assemble(Serializable arg0, Object arg1) throws HibernateException {
        return this.deepCopy(arg0);
    }

    public Serializable disassemble(Object value) {
        return (Serializable)this.deepCopy(value);
    }

    public int hashCode(Object arg0) throws HibernateException {
        return arg0.hashCode();
    }
}

