/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.persistence;

import com.bwanms.persistence.SessionManager;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jboss.hibernate.jmx.HibernateLocal;

public class SimpleSessionManager
extends SessionManager {
    private static ThreadLocal<Session> sessionHolder = new ThreadLocal();
    private static SessionFactory sessionFactory = HibernateLocal.lookup();

    public Session getSession() {
        Session sess = sessionHolder.get();
        if (sess == null) {
            throw new HibernateException("Session not started");
        }
        return sess;
    }

    public void startSession() {
        Session sess = sessionHolder.get();
        if (sess != null) {
            throw new HibernateException("Session already started");
        }
        sessionHolder.set((Session)sessionFactory.openSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSession() {
        Session sess = sessionHolder.get();
        if (sess == null) {
            throw new HibernateException("Session not started");
        }
        try {
            sess.close();
        }
        finally {
            sessionHolder.set(null);
        }
    }
}

